/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OperationType {
    REGISTER_DOMAIN("REGISTER_DOMAIN"),
    DELETE_DOMAIN("DELETE_DOMAIN"),
    TRANSFER_IN_DOMAIN("TRANSFER_IN_DOMAIN"),
    UPDATE_DOMAIN_CONTACT("UPDATE_DOMAIN_CONTACT"),
    UPDATE_NAMESERVER("UPDATE_NAMESERVER"),
    CHANGE_PRIVACY_PROTECTION("CHANGE_PRIVACY_PROTECTION"),
    DOMAIN_LOCK("DOMAIN_LOCK"),
    ENABLE_AUTORENEW("ENABLE_AUTORENEW"),
    DISABLE_AUTORENEW("DISABLE_AUTORENEW"),
    ADD_DNSSEC("ADD_DNSSEC"),
    REMOVE_DNSSEC("REMOVE_DNSSEC"),
    EXPIRE_DOMAIN("EXPIRE_DOMAIN"),
    TRANSFER_OUT_DOMAIN("TRANSFER_OUT_DOMAIN"),
    CHANGE_DOMAIN_OWNER("CHANGE_DOMAIN_OWNER"),
    RENEW_DOMAIN("RENEW_DOMAIN"),
    PUSH_DOMAIN("PUSH_DOMAIN"),
    INTERNAL_TRANSFER_OUT_DOMAIN("INTERNAL_TRANSFER_OUT_DOMAIN"),
    INTERNAL_TRANSFER_IN_DOMAIN("INTERNAL_TRANSFER_IN_DOMAIN"),
    RELEASE_TO_GANDI("RELEASE_TO_GANDI"),
    TRANSFER_ON_RENEW("TRANSFER_ON_RENEW"),
    RESTORE_DOMAIN("RESTORE_DOMAIN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperationType> VALUE_MAP;
    private final String value;

    private OperationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperationType> knownValues() {
        EnumSet<OperationType> knownValues = EnumSet.allOf(OperationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OperationType.class, OperationType::toString);
    }
}

