/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnssecKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DnssecKey> {
    private static final SdkField<Integer> ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Algorithm").getter(DnssecKey.getter(DnssecKey::algorithm)).setter(DnssecKey.setter(Builder::algorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Algorithm").build()}).build();
    private static final SdkField<Integer> FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Flags").getter(DnssecKey.getter(DnssecKey::flags)).setter(DnssecKey.setter(Builder::flags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flags").build()}).build();
    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicKey").getter(DnssecKey.getter(DnssecKey::publicKey)).setter(DnssecKey.setter(Builder::publicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()}).build();
    private static final SdkField<Integer> DIGEST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DigestType").getter(DnssecKey.getter(DnssecKey::digestType)).setter(DnssecKey.setter(Builder::digestType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigestType").build()}).build();
    private static final SdkField<String> DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Digest").getter(DnssecKey.getter(DnssecKey::digest)).setter(DnssecKey.setter(Builder::digest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Digest").build()}).build();
    private static final SdkField<Integer> KEY_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("KeyTag").getter(DnssecKey.getter(DnssecKey::keyTag)).setter(DnssecKey.setter(Builder::keyTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyTag").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DnssecKey.getter(DnssecKey::id)).setter(DnssecKey.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, FLAGS_FIELD, PUBLIC_KEY_FIELD, DIGEST_TYPE_FIELD, DIGEST_FIELD, KEY_TAG_FIELD, ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DnssecKey.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer algorithm;
    private final Integer flags;
    private final String publicKey;
    private final Integer digestType;
    private final String digest;
    private final Integer keyTag;
    private final String id;

    private DnssecKey(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.flags = builder.flags;
        this.publicKey = builder.publicKey;
        this.digestType = builder.digestType;
        this.digest = builder.digest;
        this.keyTag = builder.keyTag;
        this.id = builder.id;
    }

    public final Integer algorithm() {
        return this.algorithm;
    }

    public final Integer flags() {
        return this.flags;
    }

    public final String publicKey() {
        return this.publicKey;
    }

    public final Integer digestType() {
        return this.digestType;
    }

    public final String digest() {
        return this.digest;
    }

    public final Integer keyTag() {
        return this.keyTag;
    }

    public final String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.flags());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.digestType());
        hashCode = 31 * hashCode + Objects.hashCode(this.digest());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnssecKey)) {
            return false;
        }
        DnssecKey other = (DnssecKey)obj;
        return Objects.equals(this.algorithm(), other.algorithm()) && Objects.equals(this.flags(), other.flags()) && Objects.equals(this.publicKey(), other.publicKey()) && Objects.equals(this.digestType(), other.digestType()) && Objects.equals(this.digest(), other.digest()) && Objects.equals(this.keyTag(), other.keyTag()) && Objects.equals(this.id(), other.id());
    }

    public final String toString() {
        return ToString.builder((String)"DnssecKey").add("Algorithm", (Object)this.algorithm()).add("Flags", (Object)this.flags()).add("PublicKey", (Object)this.publicKey()).add("DigestType", (Object)this.digestType()).add("Digest", (Object)this.digest()).add("KeyTag", (Object)this.keyTag()).add("Id", (Object)this.id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Algorithm": {
                return Optional.ofNullable(clazz.cast(this.algorithm()));
            }
            case "Flags": {
                return Optional.ofNullable(clazz.cast(this.flags()));
            }
            case "PublicKey": {
                return Optional.ofNullable(clazz.cast(this.publicKey()));
            }
            case "DigestType": {
                return Optional.ofNullable(clazz.cast(this.digestType()));
            }
            case "Digest": {
                return Optional.ofNullable(clazz.cast(this.digest()));
            }
            case "KeyTag": {
                return Optional.ofNullable(clazz.cast(this.keyTag()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Algorithm", ALGORITHM_FIELD);
        map.put("Flags", FLAGS_FIELD);
        map.put("PublicKey", PUBLIC_KEY_FIELD);
        map.put("DigestType", DIGEST_TYPE_FIELD);
        map.put("Digest", DIGEST_FIELD);
        map.put("KeyTag", KEY_TAG_FIELD);
        map.put("Id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DnssecKey, T> g) {
        return obj -> g.apply((DnssecKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer algorithm;
        private Integer flags;
        private String publicKey;
        private Integer digestType;
        private String digest;
        private Integer keyTag;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(DnssecKey model) {
            this.algorithm(model.algorithm);
            this.flags(model.flags);
            this.publicKey(model.publicKey);
            this.digestType(model.digestType);
            this.digest(model.digest);
            this.keyTag(model.keyTag);
            this.id(model.id);
        }

        public final Integer getAlgorithm() {
            return this.algorithm;
        }

        public final void setAlgorithm(Integer algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public final Builder algorithm(Integer algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public final Integer getFlags() {
            return this.flags;
        }

        public final void setFlags(Integer flags) {
            this.flags = flags;
        }

        @Override
        public final Builder flags(Integer flags) {
            this.flags = flags;
            return this;
        }

        public final String getPublicKey() {
            return this.publicKey;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final Integer getDigestType() {
            return this.digestType;
        }

        public final void setDigestType(Integer digestType) {
            this.digestType = digestType;
        }

        @Override
        public final Builder digestType(Integer digestType) {
            this.digestType = digestType;
            return this;
        }

        public final String getDigest() {
            return this.digest;
        }

        public final void setDigest(String digest) {
            this.digest = digest;
        }

        @Override
        public final Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public final Integer getKeyTag() {
            return this.keyTag;
        }

        public final void setKeyTag(Integer keyTag) {
            this.keyTag = keyTag;
        }

        @Override
        public final Builder keyTag(Integer keyTag) {
            this.keyTag = keyTag;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public DnssecKey build() {
            return new DnssecKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DnssecKey> {
        public Builder algorithm(Integer var1);

        public Builder flags(Integer var1);

        public Builder publicKey(String var1);

        public Builder digestType(Integer var1);

        public Builder digest(String var1);

        public Builder keyTag(Integer var1);

        public Builder id(String var1);
    }
}

