/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.route53domains.model.BillingRecord;
import software.amazon.awssdk.services.route53domains.model.BillingRecordsCopier;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ViewBillingResponse
extends Route53DomainsResponse
implements ToCopyableBuilder<Builder, ViewBillingResponse> {
    private static final SdkField<String> NEXT_PAGE_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ViewBillingResponse.getter(ViewBillingResponse::nextPageMarker)).setter(ViewBillingResponse.setter(Builder::nextPageMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageMarker").build()}).build();
    private static final SdkField<List<BillingRecord>> BILLING_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ViewBillingResponse.getter(ViewBillingResponse::billingRecords)).setter(ViewBillingResponse.setter(Builder::billingRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BillingRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_PAGE_MARKER_FIELD, BILLING_RECORDS_FIELD));
    private final String nextPageMarker;
    private final List<BillingRecord> billingRecords;

    private ViewBillingResponse(BuilderImpl builder) {
        super(builder);
        this.nextPageMarker = builder.nextPageMarker;
        this.billingRecords = builder.billingRecords;
    }

    public String nextPageMarker() {
        return this.nextPageMarker;
    }

    public List<BillingRecord> billingRecords() {
        return this.billingRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingRecords());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewBillingResponse)) {
            return false;
        }
        ViewBillingResponse other = (ViewBillingResponse)((Object)obj);
        return Objects.equals(this.nextPageMarker(), other.nextPageMarker()) && Objects.equals(this.billingRecords(), other.billingRecords());
    }

    public String toString() {
        return ToString.builder((String)"ViewBillingResponse").add("NextPageMarker", (Object)this.nextPageMarker()).add("BillingRecords", this.billingRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextPageMarker": {
                return Optional.ofNullable(clazz.cast(this.nextPageMarker()));
            }
            case "BillingRecords": {
                return Optional.ofNullable(clazz.cast(this.billingRecords()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ViewBillingResponse, T> g) {
        return obj -> g.apply((ViewBillingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsResponse.BuilderImpl
    implements Builder {
        private String nextPageMarker;
        private List<BillingRecord> billingRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ViewBillingResponse model) {
            super(model);
            this.nextPageMarker(model.nextPageMarker);
            this.billingRecords(model.billingRecords);
        }

        public final String getNextPageMarker() {
            return this.nextPageMarker;
        }

        @Override
        public final Builder nextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
            return this;
        }

        public final void setNextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
        }

        public final Collection<BillingRecord.Builder> getBillingRecords() {
            return this.billingRecords != null ? (Collection)this.billingRecords.stream().map(BillingRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder billingRecords(Collection<BillingRecord> billingRecords) {
            this.billingRecords = BillingRecordsCopier.copy(billingRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingRecords(BillingRecord ... billingRecords) {
            this.billingRecords(Arrays.asList(billingRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingRecords(Consumer<BillingRecord.Builder> ... billingRecords) {
            this.billingRecords(Stream.of(billingRecords).map(c -> (BillingRecord)((BillingRecord.Builder)BillingRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBillingRecords(Collection<BillingRecord.BuilderImpl> billingRecords) {
            this.billingRecords = BillingRecordsCopier.copyFromBuilder(billingRecords);
        }

        @Override
        public ViewBillingResponse build() {
            return new ViewBillingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ViewBillingResponse> {
        public Builder nextPageMarker(String var1);

        public Builder billingRecords(Collection<BillingRecord> var1);

        public Builder billingRecords(BillingRecord ... var1);

        public Builder billingRecords(Consumer<BillingRecord.Builder> ... var1);
    }
}

