/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RenewDomainRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, RenewDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RenewDomainRequest.getter(RenewDomainRequest::domainName)).setter(RenewDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<Integer> DURATION_IN_YEARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(RenewDomainRequest.getter(RenewDomainRequest::durationInYears)).setter(RenewDomainRequest.setter(Builder::durationInYears)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInYears").build()}).build();
    private static final SdkField<Integer> CURRENT_EXPIRY_YEAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(RenewDomainRequest.getter(RenewDomainRequest::currentExpiryYear)).setter(RenewDomainRequest.setter(Builder::currentExpiryYear)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentExpiryYear").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, DURATION_IN_YEARS_FIELD, CURRENT_EXPIRY_YEAR_FIELD));
    private final String domainName;
    private final Integer durationInYears;
    private final Integer currentExpiryYear;

    private RenewDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.durationInYears = builder.durationInYears;
        this.currentExpiryYear = builder.currentExpiryYear;
    }

    public String domainName() {
        return this.domainName;
    }

    public Integer durationInYears() {
        return this.durationInYears;
    }

    public Integer currentExpiryYear() {
        return this.currentExpiryYear;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInYears());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentExpiryYear());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewDomainRequest)) {
            return false;
        }
        RenewDomainRequest other = (RenewDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.durationInYears(), other.durationInYears()) && Objects.equals(this.currentExpiryYear(), other.currentExpiryYear());
    }

    public String toString() {
        return ToString.builder((String)"RenewDomainRequest").add("DomainName", (Object)this.domainName()).add("DurationInYears", (Object)this.durationInYears()).add("CurrentExpiryYear", (Object)this.currentExpiryYear()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DurationInYears": {
                return Optional.ofNullable(clazz.cast(this.durationInYears()));
            }
            case "CurrentExpiryYear": {
                return Optional.ofNullable(clazz.cast(this.currentExpiryYear()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RenewDomainRequest, T> g) {
        return obj -> g.apply((RenewDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private Integer durationInYears;
        private Integer currentExpiryYear;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewDomainRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.durationInYears(model.durationInYears);
            this.currentExpiryYear(model.currentExpiryYear);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Integer getDurationInYears() {
            return this.durationInYears;
        }

        @Override
        public final Builder durationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
            return this;
        }

        public final void setDurationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
        }

        public final Integer getCurrentExpiryYear() {
            return this.currentExpiryYear;
        }

        @Override
        public final Builder currentExpiryYear(Integer currentExpiryYear) {
            this.currentExpiryYear = currentExpiryYear;
            return this;
        }

        public final void setCurrentExpiryYear(Integer currentExpiryYear) {
            this.currentExpiryYear = currentExpiryYear;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RenewDomainRequest build() {
            return new RenewDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RenewDomainRequest> {
        public Builder domainName(String var1);

        public Builder durationInYears(Integer var1);

        public Builder currentExpiryYear(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

