/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53domains.model.OperationStatus;
import software.amazon.awssdk.services.route53domains.model.OperationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OperationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OperationSummary> {
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OperationSummary.getter(OperationSummary::operationId)).setter(OperationSummary.setter(Builder::operationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OperationSummary.getter(OperationSummary::statusAsString)).setter(OperationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OperationSummary.getter(OperationSummary::typeAsString)).setter(OperationSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Instant> SUBMITTED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(OperationSummary.getter(OperationSummary::submittedDate)).setter(OperationSummary.setter(Builder::submittedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_ID_FIELD, STATUS_FIELD, TYPE_FIELD, SUBMITTED_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String operationId;
    private final String status;
    private final String type;
    private final Instant submittedDate;

    private OperationSummary(BuilderImpl builder) {
        this.operationId = builder.operationId;
        this.status = builder.status;
        this.type = builder.type;
        this.submittedDate = builder.submittedDate;
    }

    public String operationId() {
        return this.operationId;
    }

    public OperationStatus status() {
        return OperationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public OperationType type() {
        return OperationType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Instant submittedDate() {
        return this.submittedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationSummary)) {
            return false;
        }
        OperationSummary other = (OperationSummary)obj;
        return Objects.equals(this.operationId(), other.operationId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.submittedDate(), other.submittedDate());
    }

    public String toString() {
        return ToString.builder((String)"OperationSummary").add("OperationId", (Object)this.operationId()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).add("SubmittedDate", (Object)this.submittedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SubmittedDate": {
                return Optional.ofNullable(clazz.cast(this.submittedDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OperationSummary, T> g) {
        return obj -> g.apply((OperationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operationId;
        private String status;
        private String type;
        private Instant submittedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationSummary model) {
            this.operationId(model.operationId);
            this.status(model.status);
            this.type(model.type);
            this.submittedDate(model.submittedDate);
        }

        public final String getOperationId() {
            return this.operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getSubmittedDate() {
            return this.submittedDate;
        }

        @Override
        public final Builder submittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
            return this;
        }

        public final void setSubmittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
        }

        public OperationSummary build() {
            return new OperationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OperationSummary> {
        public Builder operationId(String var1);

        public Builder status(String var1);

        public Builder status(OperationStatus var1);

        public Builder type(String var1);

        public Builder type(OperationType var1);

        public Builder submittedDate(Instant var1);
    }
}

