/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53domains.model.OperationStatus;
import software.amazon.awssdk.services.route53domains.model.OperationType;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOperationDetailResponse
extends Route53DomainsResponse
implements ToCopyableBuilder<Builder, GetOperationDetailResponse> {
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetOperationDetailResponse.getter(GetOperationDetailResponse::operationId)).setter(GetOperationDetailResponse.setter(Builder::operationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetOperationDetailResponse.getter(GetOperationDetailResponse::statusAsString)).setter(GetOperationDetailResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetOperationDetailResponse.getter(GetOperationDetailResponse::message)).setter(GetOperationDetailResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetOperationDetailResponse.getter(GetOperationDetailResponse::domainName)).setter(GetOperationDetailResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetOperationDetailResponse.getter(GetOperationDetailResponse::typeAsString)).setter(GetOperationDetailResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Instant> SUBMITTED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetOperationDetailResponse.getter(GetOperationDetailResponse::submittedDate)).setter(GetOperationDetailResponse.setter(Builder::submittedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_ID_FIELD, STATUS_FIELD, MESSAGE_FIELD, DOMAIN_NAME_FIELD, TYPE_FIELD, SUBMITTED_DATE_FIELD));
    private final String operationId;
    private final String status;
    private final String message;
    private final String domainName;
    private final String type;
    private final Instant submittedDate;

    private GetOperationDetailResponse(BuilderImpl builder) {
        super(builder);
        this.operationId = builder.operationId;
        this.status = builder.status;
        this.message = builder.message;
        this.domainName = builder.domainName;
        this.type = builder.type;
        this.submittedDate = builder.submittedDate;
    }

    public String operationId() {
        return this.operationId;
    }

    public OperationStatus status() {
        return OperationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public String domainName() {
        return this.domainName;
    }

    public OperationType type() {
        return OperationType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Instant submittedDate() {
        return this.submittedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationDetailResponse)) {
            return false;
        }
        GetOperationDetailResponse other = (GetOperationDetailResponse)((Object)obj);
        return Objects.equals(this.operationId(), other.operationId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.submittedDate(), other.submittedDate());
    }

    public String toString() {
        return ToString.builder((String)"GetOperationDetailResponse").add("OperationId", (Object)this.operationId()).add("Status", (Object)this.statusAsString()).add("Message", (Object)this.message()).add("DomainName", (Object)this.domainName()).add("Type", (Object)this.typeAsString()).add("SubmittedDate", (Object)this.submittedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SubmittedDate": {
                return Optional.ofNullable(clazz.cast(this.submittedDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOperationDetailResponse, T> g) {
        return obj -> g.apply((GetOperationDetailResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsResponse.BuilderImpl
    implements Builder {
        private String operationId;
        private String status;
        private String message;
        private String domainName;
        private String type;
        private Instant submittedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationDetailResponse model) {
            super(model);
            this.operationId(model.operationId);
            this.status(model.status);
            this.message(model.message);
            this.domainName(model.domainName);
            this.type(model.type);
            this.submittedDate(model.submittedDate);
        }

        public final String getOperationId() {
            return this.operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getSubmittedDate() {
            return this.submittedDate;
        }

        @Override
        public final Builder submittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
            return this;
        }

        public final void setSubmittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
        }

        @Override
        public GetOperationDetailResponse build() {
            return new GetOperationDetailResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOperationDetailResponse> {
        public Builder operationId(String var1);

        public Builder status(String var1);

        public Builder status(OperationStatus var1);

        public Builder message(String var1);

        public Builder domainName(String var1);

        public Builder type(String var1);

        public Builder type(OperationType var1);

        public Builder submittedDate(Instant var1);
    }
}

