/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Consent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Consent> {
    private static final SdkField<Double> MAX_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxPrice").getter(Consent.getter(Consent::maxPrice)).setter(Consent.setter(Builder::maxPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice").build()}).build();
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Currency").getter(Consent.getter(Consent::currency)).setter(Consent.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Currency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_PRICE_FIELD, CURRENCY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double maxPrice;
    private final String currency;

    private Consent(BuilderImpl builder) {
        this.maxPrice = builder.maxPrice;
        this.currency = builder.currency;
    }

    public final Double maxPrice() {
        return this.maxPrice;
    }

    public final String currency() {
        return this.currency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.currency());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Consent)) {
            return false;
        }
        Consent other = (Consent)obj;
        return Objects.equals(this.maxPrice(), other.maxPrice()) && Objects.equals(this.currency(), other.currency());
    }

    public final String toString() {
        return ToString.builder((String)"Consent").add("MaxPrice", (Object)this.maxPrice()).add("Currency", (Object)this.currency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxPrice": {
                return Optional.ofNullable(clazz.cast(this.maxPrice()));
            }
            case "Currency": {
                return Optional.ofNullable(clazz.cast(this.currency()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Consent, T> g) {
        return obj -> g.apply((Consent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double maxPrice;
        private String currency;

        private BuilderImpl() {
        }

        private BuilderImpl(Consent model) {
            this.maxPrice(model.maxPrice);
            this.currency(model.currency);
        }

        public final Double getMaxPrice() {
            return this.maxPrice;
        }

        public final void setMaxPrice(Double maxPrice) {
            this.maxPrice = maxPrice;
        }

        @Override
        public final Builder maxPrice(Double maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final String getCurrency() {
            return this.currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Consent build() {
            return new Consent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Consent> {
        public Builder maxPrice(Double var1);

        public Builder currency(String var1);
    }
}

