/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDomainSuggestionsRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, GetDomainSuggestionsRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(GetDomainSuggestionsRequest.getter(GetDomainSuggestionsRequest::domainName)).setter(GetDomainSuggestionsRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<Integer> SUGGESTION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SuggestionCount").getter(GetDomainSuggestionsRequest.getter(GetDomainSuggestionsRequest::suggestionCount)).setter(GetDomainSuggestionsRequest.setter(Builder::suggestionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestionCount").build()}).build();
    private static final SdkField<Boolean> ONLY_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OnlyAvailable").getter(GetDomainSuggestionsRequest.getter(GetDomainSuggestionsRequest::onlyAvailable)).setter(GetDomainSuggestionsRequest.setter(Builder::onlyAvailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlyAvailable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, SUGGESTION_COUNT_FIELD, ONLY_AVAILABLE_FIELD));
    private final String domainName;
    private final Integer suggestionCount;
    private final Boolean onlyAvailable;

    private GetDomainSuggestionsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.suggestionCount = builder.suggestionCount;
        this.onlyAvailable = builder.onlyAvailable;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final Integer suggestionCount() {
        return this.suggestionCount;
    }

    public final Boolean onlyAvailable() {
        return this.onlyAvailable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggestionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlyAvailable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainSuggestionsRequest)) {
            return false;
        }
        GetDomainSuggestionsRequest other = (GetDomainSuggestionsRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.suggestionCount(), other.suggestionCount()) && Objects.equals(this.onlyAvailable(), other.onlyAvailable());
    }

    public final String toString() {
        return ToString.builder((String)"GetDomainSuggestionsRequest").add("DomainName", (Object)this.domainName()).add("SuggestionCount", (Object)this.suggestionCount()).add("OnlyAvailable", (Object)this.onlyAvailable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "SuggestionCount": {
                return Optional.ofNullable(clazz.cast(this.suggestionCount()));
            }
            case "OnlyAvailable": {
                return Optional.ofNullable(clazz.cast(this.onlyAvailable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainSuggestionsRequest, T> g) {
        return obj -> g.apply((GetDomainSuggestionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private Integer suggestionCount;
        private Boolean onlyAvailable;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainSuggestionsRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.suggestionCount(model.suggestionCount);
            this.onlyAvailable(model.onlyAvailable);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Integer getSuggestionCount() {
            return this.suggestionCount;
        }

        @Override
        public final Builder suggestionCount(Integer suggestionCount) {
            this.suggestionCount = suggestionCount;
            return this;
        }

        public final void setSuggestionCount(Integer suggestionCount) {
            this.suggestionCount = suggestionCount;
        }

        public final Boolean getOnlyAvailable() {
            return this.onlyAvailable;
        }

        @Override
        public final Builder onlyAvailable(Boolean onlyAvailable) {
            this.onlyAvailable = onlyAvailable;
            return this;
        }

        public final void setOnlyAvailable(Boolean onlyAvailable) {
            this.onlyAvailable = onlyAvailable;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDomainSuggestionsRequest build() {
            return new GetDomainSuggestionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDomainSuggestionsRequest> {
        public Builder domainName(String var1);

        public Builder suggestionCount(Integer var1);

        public Builder onlyAvailable(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

