/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckDomainAvailabilityRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, CheckDomainAvailabilityRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CheckDomainAvailabilityRequest.getter(CheckDomainAvailabilityRequest::domainName)).setter(CheckDomainAvailabilityRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> IDN_LANG_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdnLangCode").getter(CheckDomainAvailabilityRequest.getter(CheckDomainAvailabilityRequest::idnLangCode)).setter(CheckDomainAvailabilityRequest.setter(Builder::idnLangCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdnLangCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, IDN_LANG_CODE_FIELD));
    private final String domainName;
    private final String idnLangCode;

    private CheckDomainAvailabilityRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.idnLangCode = builder.idnLangCode;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String idnLangCode() {
        return this.idnLangCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.idnLangCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDomainAvailabilityRequest)) {
            return false;
        }
        CheckDomainAvailabilityRequest other = (CheckDomainAvailabilityRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.idnLangCode(), other.idnLangCode());
    }

    public final String toString() {
        return ToString.builder((String)"CheckDomainAvailabilityRequest").add("DomainName", (Object)this.domainName()).add("IdnLangCode", (Object)this.idnLangCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "IdnLangCode": {
                return Optional.ofNullable(clazz.cast(this.idnLangCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckDomainAvailabilityRequest, T> g) {
        return obj -> g.apply((CheckDomainAvailabilityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String idnLangCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDomainAvailabilityRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.idnLangCode(model.idnLangCode);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getIdnLangCode() {
            return this.idnLangCode;
        }

        @Override
        public final Builder idnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
            return this;
        }

        public final void setIdnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckDomainAvailabilityRequest build() {
            return new CheckDomainAvailabilityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckDomainAvailabilityRequest> {
        public Builder domainName(String var1);

        public Builder idnLangCode(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

