/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.services.route53domains.model.TagKeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteTagsForDomainRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, DeleteTagsForDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DeleteTagsForDomainRequest.getter(DeleteTagsForDomainRequest::domainName)).setter(DeleteTagsForDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<List<String>> TAGS_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagsToDelete").getter(DeleteTagsForDomainRequest.getter(DeleteTagsForDomainRequest::tagsToDelete)).setter(DeleteTagsForDomainRequest.setter(Builder::tagsToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, TAGS_TO_DELETE_FIELD));
    private final String domainName;
    private final List<String> tagsToDelete;

    private DeleteTagsForDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.tagsToDelete = builder.tagsToDelete;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final boolean hasTagsToDelete() {
        return this.tagsToDelete != null && !(this.tagsToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> tagsToDelete() {
        return this.tagsToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagsToDelete() ? this.tagsToDelete() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTagsForDomainRequest)) {
            return false;
        }
        DeleteTagsForDomainRequest other = (DeleteTagsForDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && this.hasTagsToDelete() == other.hasTagsToDelete() && Objects.equals(this.tagsToDelete(), other.tagsToDelete());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteTagsForDomainRequest").add("DomainName", (Object)this.domainName()).add("TagsToDelete", this.hasTagsToDelete() ? this.tagsToDelete() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "TagsToDelete": {
                return Optional.ofNullable(clazz.cast(this.tagsToDelete()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTagsForDomainRequest, T> g) {
        return obj -> g.apply((DeleteTagsForDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> tagsToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTagsForDomainRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.tagsToDelete(model.tagsToDelete);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getTagsToDelete() {
            if (this.tagsToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagsToDelete;
        }

        @Override
        public final Builder tagsToDelete(Collection<String> tagsToDelete) {
            this.tagsToDelete = TagKeyListCopier.copy(tagsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToDelete(String ... tagsToDelete) {
            this.tagsToDelete(Arrays.asList(tagsToDelete));
            return this;
        }

        public final void setTagsToDelete(Collection<String> tagsToDelete) {
            this.tagsToDelete = TagKeyListCopier.copy(tagsToDelete);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTagsForDomainRequest build() {
            return new DeleteTagsForDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteTagsForDomainRequest> {
        public Builder domainName(String var1);

        public Builder tagsToDelete(Collection<String> var1);

        public Builder tagsToDelete(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

