/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53domains.model.ContactDetail;
import software.amazon.awssdk.services.route53domains.model.Nameserver;
import software.amazon.awssdk.services.route53domains.model.NameserverListCopier;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransferDomainRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, TransferDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransferDomainRequest.getter(TransferDomainRequest::domainName)).setter(TransferDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> IDN_LANG_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransferDomainRequest.getter(TransferDomainRequest::idnLangCode)).setter(TransferDomainRequest.setter(Builder::idnLangCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdnLangCode").build()}).build();
    private static final SdkField<Integer> DURATION_IN_YEARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TransferDomainRequest.getter(TransferDomainRequest::durationInYears)).setter(TransferDomainRequest.setter(Builder::durationInYears)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInYears").build()}).build();
    private static final SdkField<List<Nameserver>> NAMESERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TransferDomainRequest.getter(TransferDomainRequest::nameservers)).setter(TransferDomainRequest.setter(Builder::nameservers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nameservers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Nameserver::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUTH_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransferDomainRequest.getter(TransferDomainRequest::authCode)).setter(TransferDomainRequest.setter(Builder::authCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthCode").build()}).build();
    private static final SdkField<Boolean> AUTO_RENEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(TransferDomainRequest.getter(TransferDomainRequest::autoRenew)).setter(TransferDomainRequest.setter(Builder::autoRenew)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRenew").build()}).build();
    private static final SdkField<ContactDetail> ADMIN_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TransferDomainRequest.getter(TransferDomainRequest::adminContact)).setter(TransferDomainRequest.setter(Builder::adminContact)).constructor(ContactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminContact").build()}).build();
    private static final SdkField<ContactDetail> REGISTRANT_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TransferDomainRequest.getter(TransferDomainRequest::registrantContact)).setter(TransferDomainRequest.setter(Builder::registrantContact)).constructor(ContactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrantContact").build()}).build();
    private static final SdkField<ContactDetail> TECH_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TransferDomainRequest.getter(TransferDomainRequest::techContact)).setter(TransferDomainRequest.setter(Builder::techContact)).constructor(ContactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TechContact").build()}).build();
    private static final SdkField<Boolean> PRIVACY_PROTECT_ADMIN_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(TransferDomainRequest.getter(TransferDomainRequest::privacyProtectAdminContact)).setter(TransferDomainRequest.setter(Builder::privacyProtectAdminContact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivacyProtectAdminContact").build()}).build();
    private static final SdkField<Boolean> PRIVACY_PROTECT_REGISTRANT_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(TransferDomainRequest.getter(TransferDomainRequest::privacyProtectRegistrantContact)).setter(TransferDomainRequest.setter(Builder::privacyProtectRegistrantContact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivacyProtectRegistrantContact").build()}).build();
    private static final SdkField<Boolean> PRIVACY_PROTECT_TECH_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(TransferDomainRequest.getter(TransferDomainRequest::privacyProtectTechContact)).setter(TransferDomainRequest.setter(Builder::privacyProtectTechContact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivacyProtectTechContact").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, IDN_LANG_CODE_FIELD, DURATION_IN_YEARS_FIELD, NAMESERVERS_FIELD, AUTH_CODE_FIELD, AUTO_RENEW_FIELD, ADMIN_CONTACT_FIELD, REGISTRANT_CONTACT_FIELD, TECH_CONTACT_FIELD, PRIVACY_PROTECT_ADMIN_CONTACT_FIELD, PRIVACY_PROTECT_REGISTRANT_CONTACT_FIELD, PRIVACY_PROTECT_TECH_CONTACT_FIELD));
    private final String domainName;
    private final String idnLangCode;
    private final Integer durationInYears;
    private final List<Nameserver> nameservers;
    private final String authCode;
    private final Boolean autoRenew;
    private final ContactDetail adminContact;
    private final ContactDetail registrantContact;
    private final ContactDetail techContact;
    private final Boolean privacyProtectAdminContact;
    private final Boolean privacyProtectRegistrantContact;
    private final Boolean privacyProtectTechContact;

    private TransferDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.idnLangCode = builder.idnLangCode;
        this.durationInYears = builder.durationInYears;
        this.nameservers = builder.nameservers;
        this.authCode = builder.authCode;
        this.autoRenew = builder.autoRenew;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
        this.privacyProtectAdminContact = builder.privacyProtectAdminContact;
        this.privacyProtectRegistrantContact = builder.privacyProtectRegistrantContact;
        this.privacyProtectTechContact = builder.privacyProtectTechContact;
    }

    public String domainName() {
        return this.domainName;
    }

    public String idnLangCode() {
        return this.idnLangCode;
    }

    public Integer durationInYears() {
        return this.durationInYears;
    }

    public boolean hasNameservers() {
        return this.nameservers != null && !(this.nameservers instanceof SdkAutoConstructList);
    }

    public List<Nameserver> nameservers() {
        return this.nameservers;
    }

    public String authCode() {
        return this.authCode;
    }

    public Boolean autoRenew() {
        return this.autoRenew;
    }

    public ContactDetail adminContact() {
        return this.adminContact;
    }

    public ContactDetail registrantContact() {
        return this.registrantContact;
    }

    public ContactDetail techContact() {
        return this.techContact;
    }

    public Boolean privacyProtectAdminContact() {
        return this.privacyProtectAdminContact;
    }

    public Boolean privacyProtectRegistrantContact() {
        return this.privacyProtectRegistrantContact;
    }

    public Boolean privacyProtectTechContact() {
        return this.privacyProtectTechContact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.idnLangCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInYears());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameservers());
        hashCode = 31 * hashCode + Objects.hashCode(this.authCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.techContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyProtectAdminContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyProtectRegistrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyProtectTechContact());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferDomainRequest)) {
            return false;
        }
        TransferDomainRequest other = (TransferDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.idnLangCode(), other.idnLangCode()) && Objects.equals(this.durationInYears(), other.durationInYears()) && Objects.equals(this.nameservers(), other.nameservers()) && Objects.equals(this.authCode(), other.authCode()) && Objects.equals(this.autoRenew(), other.autoRenew()) && Objects.equals(this.adminContact(), other.adminContact()) && Objects.equals(this.registrantContact(), other.registrantContact()) && Objects.equals(this.techContact(), other.techContact()) && Objects.equals(this.privacyProtectAdminContact(), other.privacyProtectAdminContact()) && Objects.equals(this.privacyProtectRegistrantContact(), other.privacyProtectRegistrantContact()) && Objects.equals(this.privacyProtectTechContact(), other.privacyProtectTechContact());
    }

    public String toString() {
        return ToString.builder((String)"TransferDomainRequest").add("DomainName", (Object)this.domainName()).add("IdnLangCode", (Object)this.idnLangCode()).add("DurationInYears", (Object)this.durationInYears()).add("Nameservers", this.nameservers()).add("AuthCode", (Object)(this.authCode() == null ? null : "*** Sensitive Data Redacted ***")).add("AutoRenew", (Object)this.autoRenew()).add("AdminContact", (Object)(this.adminContact() == null ? null : "*** Sensitive Data Redacted ***")).add("RegistrantContact", (Object)(this.registrantContact() == null ? null : "*** Sensitive Data Redacted ***")).add("TechContact", (Object)(this.techContact() == null ? null : "*** Sensitive Data Redacted ***")).add("PrivacyProtectAdminContact", (Object)this.privacyProtectAdminContact()).add("PrivacyProtectRegistrantContact", (Object)this.privacyProtectRegistrantContact()).add("PrivacyProtectTechContact", (Object)this.privacyProtectTechContact()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "IdnLangCode": {
                return Optional.ofNullable(clazz.cast(this.idnLangCode()));
            }
            case "DurationInYears": {
                return Optional.ofNullable(clazz.cast(this.durationInYears()));
            }
            case "Nameservers": {
                return Optional.ofNullable(clazz.cast(this.nameservers()));
            }
            case "AuthCode": {
                return Optional.ofNullable(clazz.cast(this.authCode()));
            }
            case "AutoRenew": {
                return Optional.ofNullable(clazz.cast(this.autoRenew()));
            }
            case "AdminContact": {
                return Optional.ofNullable(clazz.cast(this.adminContact()));
            }
            case "RegistrantContact": {
                return Optional.ofNullable(clazz.cast(this.registrantContact()));
            }
            case "TechContact": {
                return Optional.ofNullable(clazz.cast(this.techContact()));
            }
            case "PrivacyProtectAdminContact": {
                return Optional.ofNullable(clazz.cast(this.privacyProtectAdminContact()));
            }
            case "PrivacyProtectRegistrantContact": {
                return Optional.ofNullable(clazz.cast(this.privacyProtectRegistrantContact()));
            }
            case "PrivacyProtectTechContact": {
                return Optional.ofNullable(clazz.cast(this.privacyProtectTechContact()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransferDomainRequest, T> g) {
        return obj -> g.apply((TransferDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String idnLangCode;
        private Integer durationInYears;
        private List<Nameserver> nameservers = DefaultSdkAutoConstructList.getInstance();
        private String authCode;
        private Boolean autoRenew;
        private ContactDetail adminContact;
        private ContactDetail registrantContact;
        private ContactDetail techContact;
        private Boolean privacyProtectAdminContact;
        private Boolean privacyProtectRegistrantContact;
        private Boolean privacyProtectTechContact;

        private BuilderImpl() {
        }

        private BuilderImpl(TransferDomainRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.idnLangCode(model.idnLangCode);
            this.durationInYears(model.durationInYears);
            this.nameservers(model.nameservers);
            this.authCode(model.authCode);
            this.autoRenew(model.autoRenew);
            this.adminContact(model.adminContact);
            this.registrantContact(model.registrantContact);
            this.techContact(model.techContact);
            this.privacyProtectAdminContact(model.privacyProtectAdminContact);
            this.privacyProtectRegistrantContact(model.privacyProtectRegistrantContact);
            this.privacyProtectTechContact(model.privacyProtectTechContact);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getIdnLangCode() {
            return this.idnLangCode;
        }

        @Override
        public final Builder idnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
            return this;
        }

        public final void setIdnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
        }

        public final Integer getDurationInYears() {
            return this.durationInYears;
        }

        @Override
        public final Builder durationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
            return this;
        }

        public final void setDurationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
        }

        public final Collection<Nameserver.Builder> getNameservers() {
            return this.nameservers != null ? (Collection)this.nameservers.stream().map(Nameserver::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Nameserver ... nameservers) {
            this.nameservers(Arrays.asList(nameservers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Consumer<Nameserver.Builder> ... nameservers) {
            this.nameservers(Stream.of(nameservers).map(c -> (Nameserver)((Nameserver.Builder)Nameserver.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNameservers(Collection<Nameserver.BuilderImpl> nameservers) {
            this.nameservers = NameserverListCopier.copyFromBuilder(nameservers);
        }

        public final String getAuthCode() {
            return this.authCode;
        }

        @Override
        public final Builder authCode(String authCode) {
            this.authCode = authCode;
            return this;
        }

        public final void setAuthCode(String authCode) {
            this.authCode = authCode;
        }

        public final Boolean getAutoRenew() {
            return this.autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final ContactDetail.Builder getAdminContact() {
            return this.adminContact != null ? this.adminContact.toBuilder() : null;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final void setAdminContact(ContactDetail.BuilderImpl adminContact) {
            this.adminContact = adminContact != null ? adminContact.build() : null;
        }

        public final ContactDetail.Builder getRegistrantContact() {
            return this.registrantContact != null ? this.registrantContact.toBuilder() : null;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final void setRegistrantContact(ContactDetail.BuilderImpl registrantContact) {
            this.registrantContact = registrantContact != null ? registrantContact.build() : null;
        }

        public final ContactDetail.Builder getTechContact() {
            return this.techContact != null ? this.techContact.toBuilder() : null;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final void setTechContact(ContactDetail.BuilderImpl techContact) {
            this.techContact = techContact != null ? techContact.build() : null;
        }

        public final Boolean getPrivacyProtectAdminContact() {
            return this.privacyProtectAdminContact;
        }

        @Override
        public final Builder privacyProtectAdminContact(Boolean privacyProtectAdminContact) {
            this.privacyProtectAdminContact = privacyProtectAdminContact;
            return this;
        }

        public final void setPrivacyProtectAdminContact(Boolean privacyProtectAdminContact) {
            this.privacyProtectAdminContact = privacyProtectAdminContact;
        }

        public final Boolean getPrivacyProtectRegistrantContact() {
            return this.privacyProtectRegistrantContact;
        }

        @Override
        public final Builder privacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact) {
            this.privacyProtectRegistrantContact = privacyProtectRegistrantContact;
            return this;
        }

        public final void setPrivacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact) {
            this.privacyProtectRegistrantContact = privacyProtectRegistrantContact;
        }

        public final Boolean getPrivacyProtectTechContact() {
            return this.privacyProtectTechContact;
        }

        @Override
        public final Builder privacyProtectTechContact(Boolean privacyProtectTechContact) {
            this.privacyProtectTechContact = privacyProtectTechContact;
            return this;
        }

        public final void setPrivacyProtectTechContact(Boolean privacyProtectTechContact) {
            this.privacyProtectTechContact = privacyProtectTechContact;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TransferDomainRequest build() {
            return new TransferDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TransferDomainRequest> {
        public Builder domainName(String var1);

        public Builder idnLangCode(String var1);

        public Builder durationInYears(Integer var1);

        public Builder nameservers(Collection<Nameserver> var1);

        public Builder nameservers(Nameserver ... var1);

        public Builder nameservers(Consumer<Nameserver.Builder> ... var1);

        public Builder authCode(String var1);

        public Builder autoRenew(Boolean var1);

        public Builder adminContact(ContactDetail var1);

        default public Builder adminContact(Consumer<ContactDetail.Builder> adminContact) {
            return this.adminContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().applyMutation(adminContact)).build());
        }

        public Builder registrantContact(ContactDetail var1);

        default public Builder registrantContact(Consumer<ContactDetail.Builder> registrantContact) {
            return this.registrantContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().applyMutation(registrantContact)).build());
        }

        public Builder techContact(ContactDetail var1);

        default public Builder techContact(Consumer<ContactDetail.Builder> techContact) {
            return this.techContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().applyMutation(techContact)).build());
        }

        public Builder privacyProtectAdminContact(Boolean var1);

        public Builder privacyProtectRegistrantContact(Boolean var1);

        public Builder privacyProtectTechContact(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

