/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDomainContactPrivacyRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, UpdateDomainContactPrivacyRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDomainContactPrivacyRequest.getter(UpdateDomainContactPrivacyRequest::domainName)).setter(UpdateDomainContactPrivacyRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<Boolean> ADMIN_PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateDomainContactPrivacyRequest.getter(UpdateDomainContactPrivacyRequest::adminPrivacy)).setter(UpdateDomainContactPrivacyRequest.setter(Builder::adminPrivacy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminPrivacy").build()}).build();
    private static final SdkField<Boolean> REGISTRANT_PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateDomainContactPrivacyRequest.getter(UpdateDomainContactPrivacyRequest::registrantPrivacy)).setter(UpdateDomainContactPrivacyRequest.setter(Builder::registrantPrivacy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrantPrivacy").build()}).build();
    private static final SdkField<Boolean> TECH_PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateDomainContactPrivacyRequest.getter(UpdateDomainContactPrivacyRequest::techPrivacy)).setter(UpdateDomainContactPrivacyRequest.setter(Builder::techPrivacy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TechPrivacy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ADMIN_PRIVACY_FIELD, REGISTRANT_PRIVACY_FIELD, TECH_PRIVACY_FIELD));
    private final String domainName;
    private final Boolean adminPrivacy;
    private final Boolean registrantPrivacy;
    private final Boolean techPrivacy;

    private UpdateDomainContactPrivacyRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.adminPrivacy = builder.adminPrivacy;
        this.registrantPrivacy = builder.registrantPrivacy;
        this.techPrivacy = builder.techPrivacy;
    }

    public String domainName() {
        return this.domainName;
    }

    public Boolean adminPrivacy() {
        return this.adminPrivacy;
    }

    public Boolean registrantPrivacy() {
        return this.registrantPrivacy;
    }

    public Boolean techPrivacy() {
        return this.techPrivacy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrantPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(this.techPrivacy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainContactPrivacyRequest)) {
            return false;
        }
        UpdateDomainContactPrivacyRequest other = (UpdateDomainContactPrivacyRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.adminPrivacy(), other.adminPrivacy()) && Objects.equals(this.registrantPrivacy(), other.registrantPrivacy()) && Objects.equals(this.techPrivacy(), other.techPrivacy());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDomainContactPrivacyRequest").add("DomainName", (Object)this.domainName()).add("AdminPrivacy", (Object)this.adminPrivacy()).add("RegistrantPrivacy", (Object)this.registrantPrivacy()).add("TechPrivacy", (Object)this.techPrivacy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "AdminPrivacy": {
                return Optional.ofNullable(clazz.cast(this.adminPrivacy()));
            }
            case "RegistrantPrivacy": {
                return Optional.ofNullable(clazz.cast(this.registrantPrivacy()));
            }
            case "TechPrivacy": {
                return Optional.ofNullable(clazz.cast(this.techPrivacy()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainContactPrivacyRequest, T> g) {
        return obj -> g.apply((UpdateDomainContactPrivacyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private Boolean adminPrivacy;
        private Boolean registrantPrivacy;
        private Boolean techPrivacy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainContactPrivacyRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.adminPrivacy(model.adminPrivacy);
            this.registrantPrivacy(model.registrantPrivacy);
            this.techPrivacy(model.techPrivacy);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Boolean getAdminPrivacy() {
            return this.adminPrivacy;
        }

        @Override
        public final Builder adminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
            return this;
        }

        public final void setAdminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
        }

        public final Boolean getRegistrantPrivacy() {
            return this.registrantPrivacy;
        }

        @Override
        public final Builder registrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
            return this;
        }

        public final void setRegistrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
        }

        public final Boolean getTechPrivacy() {
            return this.techPrivacy;
        }

        @Override
        public final Builder techPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
            return this;
        }

        public final void setTechPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainContactPrivacyRequest build() {
            return new UpdateDomainContactPrivacyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDomainContactPrivacyRequest> {
        public Builder domainName(String var1);

        public Builder adminPrivacy(Boolean var1);

        public Builder registrantPrivacy(Boolean var1);

        public Builder techPrivacy(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

