/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53domains.model.Transferable;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainTransferability
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainTransferability> {
    private static final SdkField<String> TRANSFERABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainTransferability.getter(DomainTransferability::transferableAsString)).setter(DomainTransferability.setter(Builder::transferable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transferable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFERABLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transferable;

    private DomainTransferability(BuilderImpl builder) {
        this.transferable = builder.transferable;
    }

    public Transferable transferable() {
        return Transferable.fromValue(this.transferable);
    }

    public String transferableAsString() {
        return this.transferable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transferableAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainTransferability)) {
            return false;
        }
        DomainTransferability other = (DomainTransferability)obj;
        return Objects.equals(this.transferableAsString(), other.transferableAsString());
    }

    public String toString() {
        return ToString.builder((String)"DomainTransferability").add("Transferable", (Object)this.transferableAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Transferable": {
                return Optional.ofNullable(clazz.cast(this.transferableAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainTransferability, T> g) {
        return obj -> g.apply((DomainTransferability)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transferable;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainTransferability model) {
            this.transferable(model.transferable);
        }

        public final String getTransferable() {
            return this.transferable;
        }

        @Override
        public final Builder transferable(String transferable) {
            this.transferable = transferable;
            return this;
        }

        @Override
        public final Builder transferable(Transferable transferable) {
            this.transferable(transferable == null ? null : transferable.toString());
            return this;
        }

        public final void setTransferable(String transferable) {
            this.transferable = transferable;
        }

        public DomainTransferability build() {
            return new DomainTransferability(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainTransferability> {
        public Builder transferable(String var1);

        public Builder transferable(Transferable var1);
    }
}

