/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainSummary> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainSummary.getter(DomainSummary::domainName)).setter(DomainSummary.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<Boolean> AUTO_RENEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DomainSummary.getter(DomainSummary::autoRenew)).setter(DomainSummary.setter(Builder::autoRenew)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRenew").build()}).build();
    private static final SdkField<Boolean> TRANSFER_LOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DomainSummary.getter(DomainSummary::transferLock)).setter(DomainSummary.setter(Builder::transferLock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferLock").build()}).build();
    private static final SdkField<Instant> EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DomainSummary.getter(DomainSummary::expiry)).setter(DomainSummary.setter(Builder::expiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, AUTO_RENEW_FIELD, TRANSFER_LOCK_FIELD, EXPIRY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final Boolean autoRenew;
    private final Boolean transferLock;
    private final Instant expiry;

    private DomainSummary(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.autoRenew = builder.autoRenew;
        this.transferLock = builder.transferLock;
        this.expiry = builder.expiry;
    }

    public String domainName() {
        return this.domainName;
    }

    public Boolean autoRenew() {
        return this.autoRenew;
    }

    public Boolean transferLock() {
        return this.transferLock;
    }

    public Instant expiry() {
        return this.expiry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferLock());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiry());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSummary)) {
            return false;
        }
        DomainSummary other = (DomainSummary)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.autoRenew(), other.autoRenew()) && Objects.equals(this.transferLock(), other.transferLock()) && Objects.equals(this.expiry(), other.expiry());
    }

    public String toString() {
        return ToString.builder((String)"DomainSummary").add("DomainName", (Object)this.domainName()).add("AutoRenew", (Object)this.autoRenew()).add("TransferLock", (Object)this.transferLock()).add("Expiry", (Object)this.expiry()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "AutoRenew": {
                return Optional.ofNullable(clazz.cast(this.autoRenew()));
            }
            case "TransferLock": {
                return Optional.ofNullable(clazz.cast(this.transferLock()));
            }
            case "Expiry": {
                return Optional.ofNullable(clazz.cast(this.expiry()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainSummary, T> g) {
        return obj -> g.apply((DomainSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private Boolean autoRenew;
        private Boolean transferLock;
        private Instant expiry;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSummary model) {
            this.domainName(model.domainName);
            this.autoRenew(model.autoRenew);
            this.transferLock(model.transferLock);
            this.expiry(model.expiry);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Boolean getAutoRenew() {
            return this.autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final Boolean getTransferLock() {
            return this.transferLock;
        }

        @Override
        public final Builder transferLock(Boolean transferLock) {
            this.transferLock = transferLock;
            return this;
        }

        public final void setTransferLock(Boolean transferLock) {
            this.transferLock = transferLock;
        }

        public final Instant getExpiry() {
            return this.expiry;
        }

        @Override
        public final Builder expiry(Instant expiry) {
            this.expiry = expiry;
            return this;
        }

        public final void setExpiry(Instant expiry) {
            this.expiry = expiry;
        }

        public DomainSummary build() {
            return new DomainSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainSummary> {
        public Builder domainName(String var1);

        public Builder autoRenew(Boolean var1);

        public Builder transferLock(Boolean var1);

        public Builder expiry(Instant var1);
    }
}

