/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53domains.model.DomainAvailability;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckDomainAvailabilityResponse
extends Route53DomainsResponse
implements ToCopyableBuilder<Builder, CheckDomainAvailabilityResponse> {
    private static final SdkField<String> AVAILABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CheckDomainAvailabilityResponse.getter(CheckDomainAvailabilityResponse::availabilityAsString)).setter(CheckDomainAvailabilityResponse.setter(Builder::availability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Availability").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_FIELD));
    private final String availability;

    private CheckDomainAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.availability = builder.availability;
    }

    public DomainAvailability availability() {
        return DomainAvailability.fromValue(this.availability);
    }

    public String availabilityAsString() {
        return this.availability;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDomainAvailabilityResponse)) {
            return false;
        }
        CheckDomainAvailabilityResponse other = (CheckDomainAvailabilityResponse)((Object)obj);
        return Objects.equals(this.availabilityAsString(), other.availabilityAsString());
    }

    public String toString() {
        return ToString.builder((String)"CheckDomainAvailabilityResponse").add("Availability", (Object)this.availabilityAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Availability": {
                return Optional.ofNullable(clazz.cast(this.availabilityAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckDomainAvailabilityResponse, T> g) {
        return obj -> g.apply((CheckDomainAvailabilityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsResponse.BuilderImpl
    implements Builder {
        private String availability;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDomainAvailabilityResponse model) {
            super(model);
            this.availability(model.availability);
        }

        public final String getAvailability() {
            return this.availability;
        }

        @Override
        public final Builder availability(String availability) {
            this.availability = availability;
            return this;
        }

        @Override
        public final Builder availability(DomainAvailability availability) {
            this.availability(availability == null ? null : availability.toString());
            return this;
        }

        public final void setAvailability(String availability) {
            this.availability = availability;
        }

        @Override
        public CheckDomainAvailabilityResponse build() {
            return new CheckDomainAvailabilityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckDomainAvailabilityResponse> {
        public Builder availability(String var1);

        public Builder availability(DomainAvailability var1);
    }
}

