/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53domains.model.ReachabilityStatus;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContactReachabilityStatusResponse
extends Route53DomainsResponse
implements ToCopyableBuilder<Builder, GetContactReachabilityStatusResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetContactReachabilityStatusResponse.getter(GetContactReachabilityStatusResponse::domainName)).setter(GetContactReachabilityStatusResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetContactReachabilityStatusResponse.getter(GetContactReachabilityStatusResponse::statusAsString)).setter(GetContactReachabilityStatusResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, STATUS_FIELD));
    private final String domainName;
    private final String status;

    private GetContactReachabilityStatusResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.status = builder.status;
    }

    public String domainName() {
        return this.domainName;
    }

    public ReachabilityStatus status() {
        return ReachabilityStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactReachabilityStatusResponse)) {
            return false;
        }
        GetContactReachabilityStatusResponse other = (GetContactReachabilityStatusResponse)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetContactReachabilityStatusResponse").add("DomainName", (Object)this.domainName()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContactReachabilityStatusResponse, T> g) {
        return obj -> g.apply((GetContactReachabilityStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsResponse.BuilderImpl
    implements Builder {
        private String domainName;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContactReachabilityStatusResponse model) {
            super(model);
            this.domainName(model.domainName);
            this.status(model.status);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReachabilityStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public GetContactReachabilityStatusResponse build() {
            return new GetContactReachabilityStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContactReachabilityStatusResponse> {
        public Builder domainName(String var1);

        public Builder status(String var1);

        public Builder status(ReachabilityStatus var1);
    }
}

