/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.route53domains.model.ContactType;
import software.amazon.awssdk.services.route53domains.model.CountryCode;
import software.amazon.awssdk.services.route53domains.model.ExtraParam;
import software.amazon.awssdk.services.route53domains.model.ExtraParamListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactDetail> {
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactDetail.getter(ContactDetail::firstName)).setter(ContactDetail.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactDetail.getter(ContactDetail::lastName)).setter(ContactDetail.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()}).build();
    private static final SdkField<String> CONTACT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactDetail.getter(ContactDetail::contactTypeAsString)).setter(ContactDetail.setter(Builder::contactType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactType").build()}).build();
    private static final SdkField<String> ORGANIZATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactDetail.getter(ContactDetail::organizationName)).setter(ContactDetail.setter(Builder::organizationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationName").build()}).build();
    private static final SdkField<String> ADDRESS_LINE1_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactDetail.getter(ContactDetail::addressLine1)).setter(ContactDetail.setter(Builder::addressLine1)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine1").build()}).build();
    private static final SdkField<String> ADDRESS_LINE2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactDetail.getter(ContactDetail::addressLine2)).setter(ContactDetail.setter(Builder::addressLine2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine2").build()}).build();
    private static final SdkField<String> CITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactDetail.getter(ContactDetail::city)).setter(ContactDetail.setter(Builder::city)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactDetail.getter(ContactDetail::state)).setter(ContactDetail.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactDetail.getter(ContactDetail::countryCodeAsString)).setter(ContactDetail.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()}).build();
    private static final SdkField<String> ZIP_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactDetail.getter(ContactDetail::zipCode)).setter(ContactDetail.setter(Builder::zipCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipCode").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactDetail.getter(ContactDetail::phoneNumber)).setter(ContactDetail.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactDetail.getter(ContactDetail::email)).setter(ContactDetail.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> FAX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContactDetail.getter(ContactDetail::fax)).setter(ContactDetail.setter(Builder::fax)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fax").build()}).build();
    private static final SdkField<List<ExtraParam>> EXTRA_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ContactDetail.getter(ContactDetail::extraParams)).setter(ContactDetail.setter(Builder::extraParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraParams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExtraParam::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_NAME_FIELD, LAST_NAME_FIELD, CONTACT_TYPE_FIELD, ORGANIZATION_NAME_FIELD, ADDRESS_LINE1_FIELD, ADDRESS_LINE2_FIELD, CITY_FIELD, STATE_FIELD, COUNTRY_CODE_FIELD, ZIP_CODE_FIELD, PHONE_NUMBER_FIELD, EMAIL_FIELD, FAX_FIELD, EXTRA_PARAMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String firstName;
    private final String lastName;
    private final String contactType;
    private final String organizationName;
    private final String addressLine1;
    private final String addressLine2;
    private final String city;
    private final String state;
    private final String countryCode;
    private final String zipCode;
    private final String phoneNumber;
    private final String email;
    private final String fax;
    private final List<ExtraParam> extraParams;

    private ContactDetail(BuilderImpl builder) {
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.contactType = builder.contactType;
        this.organizationName = builder.organizationName;
        this.addressLine1 = builder.addressLine1;
        this.addressLine2 = builder.addressLine2;
        this.city = builder.city;
        this.state = builder.state;
        this.countryCode = builder.countryCode;
        this.zipCode = builder.zipCode;
        this.phoneNumber = builder.phoneNumber;
        this.email = builder.email;
        this.fax = builder.fax;
        this.extraParams = builder.extraParams;
    }

    public String firstName() {
        return this.firstName;
    }

    public String lastName() {
        return this.lastName;
    }

    public ContactType contactType() {
        return ContactType.fromValue(this.contactType);
    }

    public String contactTypeAsString() {
        return this.contactType;
    }

    public String organizationName() {
        return this.organizationName;
    }

    public String addressLine1() {
        return this.addressLine1;
    }

    public String addressLine2() {
        return this.addressLine2;
    }

    public String city() {
        return this.city;
    }

    public String state() {
        return this.state;
    }

    public CountryCode countryCode() {
        return CountryCode.fromValue(this.countryCode);
    }

    public String countryCodeAsString() {
        return this.countryCode;
    }

    public String zipCode() {
        return this.zipCode;
    }

    public String phoneNumber() {
        return this.phoneNumber;
    }

    public String email() {
        return this.email;
    }

    public String fax() {
        return this.fax;
    }

    public List<ExtraParam> extraParams() {
        return this.extraParams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressLine1());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressLine2());
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.zipCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.fax());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraParams());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactDetail)) {
            return false;
        }
        ContactDetail other = (ContactDetail)obj;
        return Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.contactTypeAsString(), other.contactTypeAsString()) && Objects.equals(this.organizationName(), other.organizationName()) && Objects.equals(this.addressLine1(), other.addressLine1()) && Objects.equals(this.addressLine2(), other.addressLine2()) && Objects.equals(this.city(), other.city()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.countryCodeAsString(), other.countryCodeAsString()) && Objects.equals(this.zipCode(), other.zipCode()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.fax(), other.fax()) && Objects.equals(this.extraParams(), other.extraParams());
    }

    public String toString() {
        return ToString.builder((String)"ContactDetail").add("FirstName", (Object)this.firstName()).add("LastName", (Object)this.lastName()).add("ContactType", (Object)this.contactTypeAsString()).add("OrganizationName", (Object)this.organizationName()).add("AddressLine1", (Object)this.addressLine1()).add("AddressLine2", (Object)this.addressLine2()).add("City", (Object)this.city()).add("State", (Object)this.state()).add("CountryCode", (Object)this.countryCodeAsString()).add("ZipCode", (Object)this.zipCode()).add("PhoneNumber", (Object)this.phoneNumber()).add("Email", (Object)this.email()).add("Fax", (Object)this.fax()).add("ExtraParams", this.extraParams()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "LastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "ContactType": {
                return Optional.ofNullable(clazz.cast(this.contactTypeAsString()));
            }
            case "OrganizationName": {
                return Optional.ofNullable(clazz.cast(this.organizationName()));
            }
            case "AddressLine1": {
                return Optional.ofNullable(clazz.cast(this.addressLine1()));
            }
            case "AddressLine2": {
                return Optional.ofNullable(clazz.cast(this.addressLine2()));
            }
            case "City": {
                return Optional.ofNullable(clazz.cast(this.city()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "CountryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCodeAsString()));
            }
            case "ZipCode": {
                return Optional.ofNullable(clazz.cast(this.zipCode()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "Fax": {
                return Optional.ofNullable(clazz.cast(this.fax()));
            }
            case "ExtraParams": {
                return Optional.ofNullable(clazz.cast(this.extraParams()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContactDetail, T> g) {
        return obj -> g.apply((ContactDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String firstName;
        private String lastName;
        private String contactType;
        private String organizationName;
        private String addressLine1;
        private String addressLine2;
        private String city;
        private String state;
        private String countryCode;
        private String zipCode;
        private String phoneNumber;
        private String email;
        private String fax;
        private List<ExtraParam> extraParams = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContactDetail model) {
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.contactType(model.contactType);
            this.organizationName(model.organizationName);
            this.addressLine1(model.addressLine1);
            this.addressLine2(model.addressLine2);
            this.city(model.city);
            this.state(model.state);
            this.countryCode(model.countryCode);
            this.zipCode(model.zipCode);
            this.phoneNumber(model.phoneNumber);
            this.email(model.email);
            this.fax(model.fax);
            this.extraParams(model.extraParams);
        }

        public final String getFirstName() {
            return this.firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public final String getLastName() {
            return this.lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public final String getContactType() {
            return this.contactType;
        }

        @Override
        public final Builder contactType(String contactType) {
            this.contactType = contactType;
            return this;
        }

        @Override
        public final Builder contactType(ContactType contactType) {
            this.contactType(contactType.toString());
            return this;
        }

        public final void setContactType(String contactType) {
            this.contactType = contactType;
        }

        public final String getOrganizationName() {
            return this.organizationName;
        }

        @Override
        public final Builder organizationName(String organizationName) {
            this.organizationName = organizationName;
            return this;
        }

        public final void setOrganizationName(String organizationName) {
            this.organizationName = organizationName;
        }

        public final String getAddressLine1() {
            return this.addressLine1;
        }

        @Override
        public final Builder addressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public final void setAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
        }

        public final String getAddressLine2() {
            return this.addressLine2;
        }

        @Override
        public final Builder addressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public final void setAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
        }

        public final String getCity() {
            return this.city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @Override
        public final Builder countryCode(CountryCode countryCode) {
            this.countryCode(countryCode.toString());
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final String getZipCode() {
            return this.zipCode;
        }

        @Override
        public final Builder zipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public final void setZipCode(String zipCode) {
            this.zipCode = zipCode;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getFax() {
            return this.fax;
        }

        @Override
        public final Builder fax(String fax) {
            this.fax = fax;
            return this;
        }

        public final void setFax(String fax) {
            this.fax = fax;
        }

        public final Collection<ExtraParam.Builder> getExtraParams() {
            return this.extraParams != null ? (Collection)this.extraParams.stream().map(ExtraParam::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder extraParams(Collection<ExtraParam> extraParams) {
            this.extraParams = ExtraParamListCopier.copy(extraParams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extraParams(ExtraParam ... extraParams) {
            this.extraParams(Arrays.asList(extraParams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extraParams(Consumer<ExtraParam.Builder> ... extraParams) {
            this.extraParams(Stream.of(extraParams).map(c -> (ExtraParam)((ExtraParam.Builder)ExtraParam.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExtraParams(Collection<ExtraParam.BuilderImpl> extraParams) {
            this.extraParams = ExtraParamListCopier.copyFromBuilder(extraParams);
        }

        public ContactDetail build() {
            return new ContactDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactDetail> {
        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder contactType(String var1);

        public Builder contactType(ContactType var1);

        public Builder organizationName(String var1);

        public Builder addressLine1(String var1);

        public Builder addressLine2(String var1);

        public Builder city(String var1);

        public Builder state(String var1);

        public Builder countryCode(String var1);

        public Builder countryCode(CountryCode var1);

        public Builder zipCode(String var1);

        public Builder phoneNumber(String var1);

        public Builder email(String var1);

        public Builder fax(String var1);

        public Builder extraParams(Collection<ExtraParam> var1);

        public Builder extraParams(ExtraParam ... var1);

        public Builder extraParams(Consumer<ExtraParam.Builder> ... var1);
    }
}

