/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains general information about the hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostedZone implements SdkPojo, Serializable, ToCopyableBuilder<HostedZone.Builder, HostedZone> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(HostedZone::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(HostedZone::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CallerReference")
            .getter(getter(HostedZone::callerReference))
            .setter(setter(Builder::callerReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference")
                    .unmarshallLocationName("CallerReference").build()).build();

    private static final SdkField<HostedZoneConfig> CONFIG_FIELD = SdkField
            .<HostedZoneConfig> builder(MarshallingType.SDK_POJO)
            .memberName("Config")
            .getter(getter(HostedZone::config))
            .setter(setter(Builder::config))
            .constructor(HostedZoneConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config")
                    .unmarshallLocationName("Config").build()).build();

    private static final SdkField<Long> RESOURCE_RECORD_SET_COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ResourceRecordSetCount")
            .getter(getter(HostedZone::resourceRecordSetCount))
            .setter(setter(Builder::resourceRecordSetCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRecordSetCount")
                    .unmarshallLocationName("ResourceRecordSetCount").build()).build();

    private static final SdkField<LinkedService> LINKED_SERVICE_FIELD = SdkField
            .<LinkedService> builder(MarshallingType.SDK_POJO)
            .memberName("LinkedService")
            .getter(getter(HostedZone::linkedService))
            .setter(setter(Builder::linkedService))
            .constructor(LinkedService::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkedService")
                    .unmarshallLocationName("LinkedService").build()).build();

    private static final SdkField<HostedZoneFeatures> FEATURES_FIELD = SdkField
            .<HostedZoneFeatures> builder(MarshallingType.SDK_POJO)
            .memberName("Features")
            .getter(getter(HostedZone::features))
            .setter(setter(Builder::features))
            .constructor(HostedZoneFeatures::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Features")
                    .unmarshallLocationName("Features").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            CALLER_REFERENCE_FIELD, CONFIG_FIELD, RESOURCE_RECORD_SET_COUNT_FIELD, LINKED_SERVICE_FIELD, FEATURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String callerReference;

    private final HostedZoneConfig config;

    private final Long resourceRecordSetCount;

    private final LinkedService linkedService;

    private final HostedZoneFeatures features;

    private HostedZone(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.callerReference = builder.callerReference;
        this.config = builder.config;
        this.resourceRecordSetCount = builder.resourceRecordSetCount;
        this.linkedService = builder.linkedService;
        this.features = builder.features;
    }

    /**
     * <p>
     * The ID that Amazon Route 53 assigned to the hosted zone when you created it.
     * </p>
     * 
     * @return The ID that Amazon Route 53 assigned to the hosted zone when you created it.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the domain. For public hosted zones, this is the name that you have registered with your DNS
     * registrar.
     * </p>
     * <p>
     * For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and <code>-</code>
     * (hyphen) and how to specify internationalized domain names, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHostedZone.html">CreateHostedZone</a>.
     * </p>
     * 
     * @return The name of the domain. For public hosted zones, this is the name that you have registered with your DNS
     *         registrar.</p>
     *         <p>
     *         For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and
     *         <code>-</code> (hyphen) and how to specify internationalized domain names, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHostedZone.html"
     *         >CreateHostedZone</a>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The value that you specified for <code>CallerReference</code> when you created the hosted zone.
     * </p>
     * 
     * @return The value that you specified for <code>CallerReference</code> when you created the hosted zone.
     */
    public final String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * A complex type that includes the <code>Comment</code> and <code>PrivateZone</code> elements. If you omitted the
     * <code>HostedZoneConfig</code> and <code>Comment</code> elements from the request, the <code>Config</code> and
     * <code>Comment</code> elements don't appear in the response.
     * </p>
     * 
     * @return A complex type that includes the <code>Comment</code> and <code>PrivateZone</code> elements. If you
     *         omitted the <code>HostedZoneConfig</code> and <code>Comment</code> elements from the request, the
     *         <code>Config</code> and <code>Comment</code> elements don't appear in the response.
     */
    public final HostedZoneConfig config() {
        return config;
    }

    /**
     * <p>
     * The number of resource record sets in the hosted zone.
     * </p>
     * 
     * @return The number of resource record sets in the hosted zone.
     */
    public final Long resourceRecordSetCount() {
        return resourceRecordSetCount;
    }

    /**
     * <p>
     * If the hosted zone was created by another service, the service that created the hosted zone. When a hosted zone
     * is created by another service, you can't edit or delete it using Route 53.
     * </p>
     * 
     * @return If the hosted zone was created by another service, the service that created the hosted zone. When a
     *         hosted zone is created by another service, you can't edit or delete it using Route 53.
     */
    public final LinkedService linkedService() {
        return linkedService;
    }

    /**
     * <p>
     * The features configuration for the hosted zone, including accelerated recovery settings and status information.
     * </p>
     * 
     * @return The features configuration for the hosted zone, including accelerated recovery settings and status
     *         information.
     */
    public final HostedZoneFeatures features() {
        return features;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(config());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRecordSetCount());
        hashCode = 31 * hashCode + Objects.hashCode(linkedService());
        hashCode = 31 * hashCode + Objects.hashCode(features());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedZone)) {
            return false;
        }
        HostedZone other = (HostedZone) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(callerReference(), other.callerReference()) && Objects.equals(config(), other.config())
                && Objects.equals(resourceRecordSetCount(), other.resourceRecordSetCount())
                && Objects.equals(linkedService(), other.linkedService()) && Objects.equals(features(), other.features());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HostedZone").add("Id", id()).add("Name", name()).add("CallerReference", callerReference())
                .add("Config", config()).add("ResourceRecordSetCount", resourceRecordSetCount())
                .add("LinkedService", linkedService()).add("Features", features()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CallerReference":
            return Optional.ofNullable(clazz.cast(callerReference()));
        case "Config":
            return Optional.ofNullable(clazz.cast(config()));
        case "ResourceRecordSetCount":
            return Optional.ofNullable(clazz.cast(resourceRecordSetCount()));
        case "LinkedService":
            return Optional.ofNullable(clazz.cast(linkedService()));
        case "Features":
            return Optional.ofNullable(clazz.cast(features()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CallerReference", CALLER_REFERENCE_FIELD);
        map.put("Config", CONFIG_FIELD);
        map.put("ResourceRecordSetCount", RESOURCE_RECORD_SET_COUNT_FIELD);
        map.put("LinkedService", LINKED_SERVICE_FIELD);
        map.put("Features", FEATURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HostedZone, T> g) {
        return obj -> g.apply((HostedZone) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HostedZone> {
        /**
         * <p>
         * The ID that Amazon Route 53 assigned to the hosted zone when you created it.
         * </p>
         * 
         * @param id
         *        The ID that Amazon Route 53 assigned to the hosted zone when you created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the domain. For public hosted zones, this is the name that you have registered with your DNS
         * registrar.
         * </p>
         * <p>
         * For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and
         * <code>-</code> (hyphen) and how to specify internationalized domain names, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHostedZone.html"
         * >CreateHostedZone</a>.
         * </p>
         * 
         * @param name
         *        The name of the domain. For public hosted zones, this is the name that you have registered with your
         *        DNS registrar.</p>
         *        <p>
         *        For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and
         *        <code>-</code> (hyphen) and how to specify internationalized domain names, see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHostedZone.html"
         *        >CreateHostedZone</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value that you specified for <code>CallerReference</code> when you created the hosted zone.
         * </p>
         * 
         * @param callerReference
         *        The value that you specified for <code>CallerReference</code> when you created the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * A complex type that includes the <code>Comment</code> and <code>PrivateZone</code> elements. If you omitted
         * the <code>HostedZoneConfig</code> and <code>Comment</code> elements from the request, the <code>Config</code>
         * and <code>Comment</code> elements don't appear in the response.
         * </p>
         * 
         * @param config
         *        A complex type that includes the <code>Comment</code> and <code>PrivateZone</code> elements. If you
         *        omitted the <code>HostedZoneConfig</code> and <code>Comment</code> elements from the request, the
         *        <code>Config</code> and <code>Comment</code> elements don't appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(HostedZoneConfig config);

        /**
         * <p>
         * A complex type that includes the <code>Comment</code> and <code>PrivateZone</code> elements. If you omitted
         * the <code>HostedZoneConfig</code> and <code>Comment</code> elements from the request, the <code>Config</code>
         * and <code>Comment</code> elements don't appear in the response.
         * </p>
         * This is a convenience method that creates an instance of the {@link HostedZoneConfig.Builder} avoiding the
         * need to create one manually via {@link HostedZoneConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HostedZoneConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #config(HostedZoneConfig)}.
         * 
         * @param config
         *        a consumer that will call methods on {@link HostedZoneConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #config(HostedZoneConfig)
         */
        default Builder config(Consumer<HostedZoneConfig.Builder> config) {
            return config(HostedZoneConfig.builder().applyMutation(config).build());
        }

        /**
         * <p>
         * The number of resource record sets in the hosted zone.
         * </p>
         * 
         * @param resourceRecordSetCount
         *        The number of resource record sets in the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecordSetCount(Long resourceRecordSetCount);

        /**
         * <p>
         * If the hosted zone was created by another service, the service that created the hosted zone. When a hosted
         * zone is created by another service, you can't edit or delete it using Route 53.
         * </p>
         * 
         * @param linkedService
         *        If the hosted zone was created by another service, the service that created the hosted zone. When a
         *        hosted zone is created by another service, you can't edit or delete it using Route 53.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedService(LinkedService linkedService);

        /**
         * <p>
         * If the hosted zone was created by another service, the service that created the hosted zone. When a hosted
         * zone is created by another service, you can't edit or delete it using Route 53.
         * </p>
         * This is a convenience method that creates an instance of the {@link LinkedService.Builder} avoiding the need
         * to create one manually via {@link LinkedService#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkedService.Builder#build()} is called immediately and its
         * result is passed to {@link #linkedService(LinkedService)}.
         * 
         * @param linkedService
         *        a consumer that will call methods on {@link LinkedService.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linkedService(LinkedService)
         */
        default Builder linkedService(Consumer<LinkedService.Builder> linkedService) {
            return linkedService(LinkedService.builder().applyMutation(linkedService).build());
        }

        /**
         * <p>
         * The features configuration for the hosted zone, including accelerated recovery settings and status
         * information.
         * </p>
         * 
         * @param features
         *        The features configuration for the hosted zone, including accelerated recovery settings and status
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(HostedZoneFeatures features);

        /**
         * <p>
         * The features configuration for the hosted zone, including accelerated recovery settings and status
         * information.
         * </p>
         * This is a convenience method that creates an instance of the {@link HostedZoneFeatures.Builder} avoiding the
         * need to create one manually via {@link HostedZoneFeatures#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HostedZoneFeatures.Builder#build()} is called immediately and its
         * result is passed to {@link #features(HostedZoneFeatures)}.
         * 
         * @param features
         *        a consumer that will call methods on {@link HostedZoneFeatures.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #features(HostedZoneFeatures)
         */
        default Builder features(Consumer<HostedZoneFeatures.Builder> features) {
            return features(HostedZoneFeatures.builder().applyMutation(features).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String callerReference;

        private HostedZoneConfig config;

        private Long resourceRecordSetCount;

        private LinkedService linkedService;

        private HostedZoneFeatures features;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedZone model) {
            id(model.id);
            name(model.name);
            callerReference(model.callerReference);
            config(model.config);
            resourceRecordSetCount(model.resourceRecordSetCount);
            linkedService(model.linkedService);
            features(model.features);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCallerReference() {
            return callerReference;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final HostedZoneConfig.Builder getConfig() {
            return config != null ? config.toBuilder() : null;
        }

        public final void setConfig(HostedZoneConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        @Override
        public final Builder config(HostedZoneConfig config) {
            this.config = config;
            return this;
        }

        public final Long getResourceRecordSetCount() {
            return resourceRecordSetCount;
        }

        public final void setResourceRecordSetCount(Long resourceRecordSetCount) {
            this.resourceRecordSetCount = resourceRecordSetCount;
        }

        @Override
        public final Builder resourceRecordSetCount(Long resourceRecordSetCount) {
            this.resourceRecordSetCount = resourceRecordSetCount;
            return this;
        }

        public final LinkedService.Builder getLinkedService() {
            return linkedService != null ? linkedService.toBuilder() : null;
        }

        public final void setLinkedService(LinkedService.BuilderImpl linkedService) {
            this.linkedService = linkedService != null ? linkedService.build() : null;
        }

        @Override
        public final Builder linkedService(LinkedService linkedService) {
            this.linkedService = linkedService;
            return this;
        }

        public final HostedZoneFeatures.Builder getFeatures() {
            return features != null ? features.toBuilder() : null;
        }

        public final void setFeatures(HostedZoneFeatures.BuilderImpl features) {
            this.features = features != null ? features.build() : null;
        }

        @Override
        public final Builder features(HostedZoneFeatures features) {
            this.features = features;
            return this;
        }

        @Override
        public HostedZone build() {
            return new HostedZone(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
