/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.route53.Route53AsyncClient;
import software.amazon.awssdk.services.route53.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.ListHostedZonesRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesResponse;

public class ListHostedZonesPublisher
implements SdkPublisher<ListHostedZonesResponse> {
    private final Route53AsyncClient client;
    private final ListHostedZonesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHostedZonesPublisher(Route53AsyncClient client, ListHostedZonesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHostedZonesPublisher(Route53AsyncClient client, ListHostedZonesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHostedZonesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHostedZonesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HostedZone> hostedZones() {
        return this.flatMapIterable(response -> response.hostedZones());
    }

    private class ListHostedZonesResponseFetcher
    implements AsyncPageFetcher<ListHostedZonesResponse> {
        private ListHostedZonesResponseFetcher() {
        }

        public boolean hasNextPage(ListHostedZonesResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListHostedZonesResponse> nextPage(ListHostedZonesResponse previousPage) {
            if (previousPage == null) {
                return ListHostedZonesPublisher.this.client.listHostedZones(ListHostedZonesPublisher.this.firstRequest);
            }
            return ListHostedZonesPublisher.this.client.listHostedZones((ListHostedZonesRequest)((Object)ListHostedZonesPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

