/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type containing tags for the specified resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagsForResourcesResponse extends Route53Response implements
        ToCopyableBuilder<ListTagsForResourcesResponse.Builder, ListTagsForResourcesResponse> {
    private static final SdkField<List<ResourceTagSet>> RESOURCE_TAG_SETS_FIELD = SdkField
            .<List<ResourceTagSet>> builder(MarshallingType.LIST)
            .memberName("ResourceTagSets")
            .getter(getter(ListTagsForResourcesResponse::resourceTagSets))
            .setter(setter(Builder::resourceTagSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTagSets")
                    .unmarshallLocationName("ResourceTagSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ResourceTagSet")
                            .memberFieldInfo(
                                    SdkField.<ResourceTagSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTagSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ResourceTagSet").unmarshallLocationName("ResourceTagSet")
                                                    .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TAG_SETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ResourceTagSet> resourceTagSets;

    private ListTagsForResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTagSets = builder.resourceTagSets;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTagSets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTagSets() {
        return resourceTagSets != null && !(resourceTagSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTagSets} method.
     * </p>
     * 
     * @return A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
     */
    public final List<ResourceTagSet> resourceTagSets() {
        return resourceTagSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTagSets() ? resourceTagSets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourcesResponse)) {
            return false;
        }
        ListTagsForResourcesResponse other = (ListTagsForResourcesResponse) obj;
        return hasResourceTagSets() == other.hasResourceTagSets() && Objects.equals(resourceTagSets(), other.resourceTagSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTagsForResourcesResponse")
                .add("ResourceTagSets", hasResourceTagSets() ? resourceTagSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceTagSets":
            return Optional.ofNullable(clazz.cast(resourceTagSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceTagSets", RESOURCE_TAG_SETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForResourcesResponse, T> g) {
        return obj -> g.apply((ListTagsForResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, ListTagsForResourcesResponse> {
        /**
         * <p>
         * A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * </p>
         * 
         * @param resourceTagSets
         *        A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagSets(Collection<ResourceTagSet> resourceTagSets);

        /**
         * <p>
         * A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * </p>
         * 
         * @param resourceTagSets
         *        A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagSets(ResourceTagSet... resourceTagSets);

        /**
         * <p>
         * A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53.model.ResourceTagSet.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.route53.model.ResourceTagSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53.model.ResourceTagSet.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceTagSets(List<ResourceTagSet>)}.
         * 
         * @param resourceTagSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53.model.ResourceTagSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTagSets(java.util.Collection<ResourceTagSet>)
         */
        Builder resourceTagSets(Consumer<ResourceTagSet.Builder>... resourceTagSets);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<ResourceTagSet> resourceTagSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourcesResponse model) {
            super(model);
            resourceTagSets(model.resourceTagSets);
        }

        public final List<ResourceTagSet.Builder> getResourceTagSets() {
            List<ResourceTagSet.Builder> result = ResourceTagSetListCopier.copyToBuilder(this.resourceTagSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTagSets(Collection<ResourceTagSet.BuilderImpl> resourceTagSets) {
            this.resourceTagSets = ResourceTagSetListCopier.copyFromBuilder(resourceTagSets);
        }

        @Override
        public final Builder resourceTagSets(Collection<ResourceTagSet> resourceTagSets) {
            this.resourceTagSets = ResourceTagSetListCopier.copy(resourceTagSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagSets(ResourceTagSet... resourceTagSets) {
            resourceTagSets(Arrays.asList(resourceTagSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagSets(Consumer<ResourceTagSet.Builder>... resourceTagSets) {
            resourceTagSets(Stream.of(resourceTagSets).map(c -> ResourceTagSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTagsForResourcesResponse build() {
            return new ListTagsForResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
