/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type containing the response information for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGeoLocationsResponse extends Route53Response implements
        ToCopyableBuilder<ListGeoLocationsResponse.Builder, ListGeoLocationsResponse> {
    private static final SdkField<List<GeoLocationDetails>> GEO_LOCATION_DETAILS_LIST_FIELD = SdkField
            .<List<GeoLocationDetails>> builder(MarshallingType.LIST)
            .memberName("GeoLocationDetailsList")
            .getter(getter(ListGeoLocationsResponse::geoLocationDetailsList))
            .setter(setter(Builder::geoLocationDetailsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoLocationDetailsList")
                    .unmarshallLocationName("GeoLocationDetailsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("GeoLocationDetails")
                            .memberFieldInfo(
                                    SdkField.<GeoLocationDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(GeoLocationDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("GeoLocationDetails")
                                                    .unmarshallLocationName("GeoLocationDetails").build()).build()).build())
            .build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated")
            .getter(getter(ListGeoLocationsResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated")
                    .unmarshallLocationName("IsTruncated").build()).build();

    private static final SdkField<String> NEXT_CONTINENT_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextContinentCode")
            .getter(getter(ListGeoLocationsResponse::nextContinentCode))
            .setter(setter(Builder::nextContinentCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextContinentCode")
                    .unmarshallLocationName("NextContinentCode").build()).build();

    private static final SdkField<String> NEXT_COUNTRY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextCountryCode")
            .getter(getter(ListGeoLocationsResponse::nextCountryCode))
            .setter(setter(Builder::nextCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextCountryCode")
                    .unmarshallLocationName("NextCountryCode").build()).build();

    private static final SdkField<String> NEXT_SUBDIVISION_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextSubdivisionCode")
            .getter(getter(ListGeoLocationsResponse::nextSubdivisionCode))
            .setter(setter(Builder::nextSubdivisionCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextSubdivisionCode")
                    .unmarshallLocationName("NextSubdivisionCode").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListGeoLocationsResponse::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GEO_LOCATION_DETAILS_LIST_FIELD, IS_TRUNCATED_FIELD, NEXT_CONTINENT_CODE_FIELD, NEXT_COUNTRY_CODE_FIELD,
            NEXT_SUBDIVISION_CODE_FIELD, MAX_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<GeoLocationDetails> geoLocationDetailsList;

    private final Boolean isTruncated;

    private final String nextContinentCode;

    private final String nextCountryCode;

    private final String nextSubdivisionCode;

    private final String maxItems;

    private ListGeoLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.geoLocationDetailsList = builder.geoLocationDetailsList;
        this.isTruncated = builder.isTruncated;
        this.nextContinentCode = builder.nextContinentCode;
        this.nextCountryCode = builder.nextCountryCode;
        this.nextSubdivisionCode = builder.nextSubdivisionCode;
        this.maxItems = builder.maxItems;
    }

    /**
     * For responses, this returns true if the service returned a value for the GeoLocationDetailsList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGeoLocationDetailsList() {
        return geoLocationDetailsList != null && !(geoLocationDetailsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route 53
     * supports for geolocation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGeoLocationDetailsList} method.
     * </p>
     * 
     * @return A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon
     *         Route 53 supports for geolocation.
     */
    public final List<GeoLocationDetails> geoLocationDetailsList() {
        return geoLocationDetailsList;
    }

    /**
     * <p>
     * A value that indicates whether more locations remain to be listed after the last location in this response. If
     * so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values, submit another request and
     * include the values of <code>NextContinentCode</code>, <code>NextCountryCode</code>, and
     * <code>NextSubdivisionCode</code> in the <code>startcontinentcode</code>, <code>startcountrycode</code>, and
     * <code>startsubdivisioncode</code>, as applicable.
     * </p>
     * 
     * @return A value that indicates whether more locations remain to be listed after the last location in this
     *         response. If so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values, submit
     *         another request and include the values of <code>NextContinentCode</code>, <code>NextCountryCode</code>,
     *         and <code>NextSubdivisionCode</code> in the <code>startcontinentcode</code>,
     *         <code>startcountrycode</code>, and <code>startsubdivisioncode</code>, as applicable.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
     * Enter the value of <code>NextContinentCode</code> in the <code>startcontinentcode</code> parameter in another
     * <code>ListGeoLocations</code> request.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
     *         locations. Enter the value of <code>NextContinentCode</code> in the <code>startcontinentcode</code>
     *         parameter in another <code>ListGeoLocations</code> request.
     */
    public final String nextContinentCode() {
        return nextContinentCode;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
     * Enter the value of <code>NextCountryCode</code> in the <code>startcountrycode</code> parameter in another
     * <code>ListGeoLocations</code> request.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
     *         locations. Enter the value of <code>NextCountryCode</code> in the <code>startcountrycode</code> parameter
     *         in another <code>ListGeoLocations</code> request.
     */
    public final String nextCountryCode() {
        return nextCountryCode;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
     * Enter the value of <code>NextSubdivisionCode</code> in the <code>startsubdivisioncode</code> parameter in another
     * <code>ListGeoLocations</code> request.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
     *         locations. Enter the value of <code>NextSubdivisionCode</code> in the <code>startsubdivisioncode</code>
     *         parameter in another <code>ListGeoLocations</code> request.
     */
    public final String nextSubdivisionCode() {
        return nextSubdivisionCode;
    }

    /**
     * <p>
     * The value that you specified for <code>MaxItems</code> in the request.
     * </p>
     * 
     * @return The value that you specified for <code>MaxItems</code> in the request.
     */
    public final String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGeoLocationDetailsList() ? geoLocationDetailsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(nextContinentCode());
        hashCode = 31 * hashCode + Objects.hashCode(nextCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(nextSubdivisionCode());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeoLocationsResponse)) {
            return false;
        }
        ListGeoLocationsResponse other = (ListGeoLocationsResponse) obj;
        return hasGeoLocationDetailsList() == other.hasGeoLocationDetailsList()
                && Objects.equals(geoLocationDetailsList(), other.geoLocationDetailsList())
                && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(nextContinentCode(), other.nextContinentCode())
                && Objects.equals(nextCountryCode(), other.nextCountryCode())
                && Objects.equals(nextSubdivisionCode(), other.nextSubdivisionCode())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGeoLocationsResponse")
                .add("GeoLocationDetailsList", hasGeoLocationDetailsList() ? geoLocationDetailsList() : null)
                .add("IsTruncated", isTruncated()).add("NextContinentCode", nextContinentCode())
                .add("NextCountryCode", nextCountryCode()).add("NextSubdivisionCode", nextSubdivisionCode())
                .add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeoLocationDetailsList":
            return Optional.ofNullable(clazz.cast(geoLocationDetailsList()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "NextContinentCode":
            return Optional.ofNullable(clazz.cast(nextContinentCode()));
        case "NextCountryCode":
            return Optional.ofNullable(clazz.cast(nextCountryCode()));
        case "NextSubdivisionCode":
            return Optional.ofNullable(clazz.cast(nextSubdivisionCode()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GeoLocationDetailsList", GEO_LOCATION_DETAILS_LIST_FIELD);
        map.put("IsTruncated", IS_TRUNCATED_FIELD);
        map.put("NextContinentCode", NEXT_CONTINENT_CODE_FIELD);
        map.put("NextCountryCode", NEXT_COUNTRY_CODE_FIELD);
        map.put("NextSubdivisionCode", NEXT_SUBDIVISION_CODE_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGeoLocationsResponse, T> g) {
        return obj -> g.apply((ListGeoLocationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, ListGeoLocationsResponse> {
        /**
         * <p>
         * A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route
         * 53 supports for geolocation.
         * </p>
         * 
         * @param geoLocationDetailsList
         *        A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon
         *        Route 53 supports for geolocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoLocationDetailsList(Collection<GeoLocationDetails> geoLocationDetailsList);

        /**
         * <p>
         * A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route
         * 53 supports for geolocation.
         * </p>
         * 
         * @param geoLocationDetailsList
         *        A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon
         *        Route 53 supports for geolocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoLocationDetailsList(GeoLocationDetails... geoLocationDetailsList);

        /**
         * <p>
         * A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route
         * 53 supports for geolocation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53.model.GeoLocationDetails.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.route53.model.GeoLocationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53.model.GeoLocationDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #geoLocationDetailsList(List<GeoLocationDetails>)}.
         * 
         * @param geoLocationDetailsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53.model.GeoLocationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geoLocationDetailsList(java.util.Collection<GeoLocationDetails>)
         */
        Builder geoLocationDetailsList(Consumer<GeoLocationDetails.Builder>... geoLocationDetailsList);

        /**
         * <p>
         * A value that indicates whether more locations remain to be listed after the last location in this response.
         * If so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values, submit another request
         * and include the values of <code>NextContinentCode</code>, <code>NextCountryCode</code>, and
         * <code>NextSubdivisionCode</code> in the <code>startcontinentcode</code>, <code>startcountrycode</code>, and
         * <code>startsubdivisioncode</code>, as applicable.
         * </p>
         * 
         * @param isTruncated
         *        A value that indicates whether more locations remain to be listed after the last location in this
         *        response. If so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values,
         *        submit another request and include the values of <code>NextContinentCode</code>,
         *        <code>NextCountryCode</code>, and <code>NextSubdivisionCode</code> in the
         *        <code>startcontinentcode</code>, <code>startcountrycode</code>, and <code>startsubdivisioncode</code>,
         *        as applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
         * Enter the value of <code>NextContinentCode</code> in the <code>startcontinentcode</code> parameter in another
         * <code>ListGeoLocations</code> request.
         * </p>
         * 
         * @param nextContinentCode
         *        If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
         *        locations. Enter the value of <code>NextContinentCode</code> in the <code>startcontinentcode</code>
         *        parameter in another <code>ListGeoLocations</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextContinentCode(String nextContinentCode);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
         * Enter the value of <code>NextCountryCode</code> in the <code>startcountrycode</code> parameter in another
         * <code>ListGeoLocations</code> request.
         * </p>
         * 
         * @param nextCountryCode
         *        If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
         *        locations. Enter the value of <code>NextCountryCode</code> in the <code>startcountrycode</code>
         *        parameter in another <code>ListGeoLocations</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextCountryCode(String nextCountryCode);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
         * Enter the value of <code>NextSubdivisionCode</code> in the <code>startsubdivisioncode</code> parameter in
         * another <code>ListGeoLocations</code> request.
         * </p>
         * 
         * @param nextSubdivisionCode
         *        If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
         *        locations. Enter the value of <code>NextSubdivisionCode</code> in the
         *        <code>startsubdivisioncode</code> parameter in another <code>ListGeoLocations</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextSubdivisionCode(String nextSubdivisionCode);

        /**
         * <p>
         * The value that you specified for <code>MaxItems</code> in the request.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for <code>MaxItems</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<GeoLocationDetails> geoLocationDetailsList = DefaultSdkAutoConstructList.getInstance();

        private Boolean isTruncated;

        private String nextContinentCode;

        private String nextCountryCode;

        private String nextSubdivisionCode;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeoLocationsResponse model) {
            super(model);
            geoLocationDetailsList(model.geoLocationDetailsList);
            isTruncated(model.isTruncated);
            nextContinentCode(model.nextContinentCode);
            nextCountryCode(model.nextCountryCode);
            nextSubdivisionCode(model.nextSubdivisionCode);
            maxItems(model.maxItems);
        }

        public final List<GeoLocationDetails.Builder> getGeoLocationDetailsList() {
            List<GeoLocationDetails.Builder> result = GeoLocationDetailsListCopier.copyToBuilder(this.geoLocationDetailsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeoLocationDetailsList(Collection<GeoLocationDetails.BuilderImpl> geoLocationDetailsList) {
            this.geoLocationDetailsList = GeoLocationDetailsListCopier.copyFromBuilder(geoLocationDetailsList);
        }

        @Override
        public final Builder geoLocationDetailsList(Collection<GeoLocationDetails> geoLocationDetailsList) {
            this.geoLocationDetailsList = GeoLocationDetailsListCopier.copy(geoLocationDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoLocationDetailsList(GeoLocationDetails... geoLocationDetailsList) {
            geoLocationDetailsList(Arrays.asList(geoLocationDetailsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoLocationDetailsList(Consumer<GeoLocationDetails.Builder>... geoLocationDetailsList) {
            geoLocationDetailsList(Stream.of(geoLocationDetailsList)
                    .map(c -> GeoLocationDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getNextContinentCode() {
            return nextContinentCode;
        }

        public final void setNextContinentCode(String nextContinentCode) {
            this.nextContinentCode = nextContinentCode;
        }

        @Override
        public final Builder nextContinentCode(String nextContinentCode) {
            this.nextContinentCode = nextContinentCode;
            return this;
        }

        public final String getNextCountryCode() {
            return nextCountryCode;
        }

        public final void setNextCountryCode(String nextCountryCode) {
            this.nextCountryCode = nextCountryCode;
        }

        @Override
        public final Builder nextCountryCode(String nextCountryCode) {
            this.nextCountryCode = nextCountryCode;
            return this;
        }

        public final String getNextSubdivisionCode() {
            return nextSubdivisionCode;
        }

        public final void setNextSubdivisionCode(String nextSubdivisionCode) {
            this.nextSubdivisionCode = nextSubdivisionCode;
        }

        @Override
        public final Builder nextSubdivisionCode(String nextSubdivisionCode) {
            this.nextSubdivisionCode = nextSubdivisionCode;
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public ListGeoLocationsResponse build() {
            return new ListGeoLocationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
