/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the CIDR collection change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CidrCollectionChange implements SdkPojo, Serializable,
        ToCopyableBuilder<CidrCollectionChange.Builder, CidrCollectionChange> {
    private static final SdkField<String> LOCATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocationName")
            .getter(getter(CidrCollectionChange::locationName))
            .setter(setter(Builder::locationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationName")
                    .unmarshallLocationName("LocationName").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Action")
            .getter(getter(CidrCollectionChange::actionAsString))
            .setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action")
                    .unmarshallLocationName("Action").build()).build();

    private static final SdkField<List<String>> CIDR_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CidrList")
            .getter(getter(CidrCollectionChange::cidrList))
            .setter(setter(Builder::cidrList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrList")
                    .unmarshallLocationName("CidrList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Cidr")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Cidr").unmarshallLocationName("Cidr").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_NAME_FIELD,
            ACTION_FIELD, CIDR_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String locationName;

    private final String action;

    private final List<String> cidrList;

    private CidrCollectionChange(BuilderImpl builder) {
        this.locationName = builder.locationName;
        this.action = builder.action;
        this.cidrList = builder.cidrList;
    }

    /**
     * <p>
     * Name of the location that is associated with the CIDR collection.
     * </p>
     * 
     * @return Name of the location that is associated with the CIDR collection.
     */
    public final String locationName() {
        return locationName;
    }

    /**
     * <p>
     * CIDR collection change action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link CidrCollectionChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return CIDR collection change action.
     * @see CidrCollectionChangeAction
     */
    public final CidrCollectionChangeAction action() {
        return CidrCollectionChangeAction.fromValue(action);
    }

    /**
     * <p>
     * CIDR collection change action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link CidrCollectionChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return CIDR collection change action.
     * @see CidrCollectionChangeAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the CidrList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCidrList() {
        return cidrList != null && !(cidrList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of CIDR blocks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCidrList} method.
     * </p>
     * 
     * @return List of CIDR blocks.
     */
    public final List<String> cidrList() {
        return cidrList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(locationName());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrList() ? cidrList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CidrCollectionChange)) {
            return false;
        }
        CidrCollectionChange other = (CidrCollectionChange) obj;
        return Objects.equals(locationName(), other.locationName()) && Objects.equals(actionAsString(), other.actionAsString())
                && hasCidrList() == other.hasCidrList() && Objects.equals(cidrList(), other.cidrList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CidrCollectionChange").add("LocationName", locationName()).add("Action", actionAsString())
                .add("CidrList", hasCidrList() ? cidrList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationName":
            return Optional.ofNullable(clazz.cast(locationName()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "CidrList":
            return Optional.ofNullable(clazz.cast(cidrList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocationName", LOCATION_NAME_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("CidrList", CIDR_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CidrCollectionChange, T> g) {
        return obj -> g.apply((CidrCollectionChange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CidrCollectionChange> {
        /**
         * <p>
         * Name of the location that is associated with the CIDR collection.
         * </p>
         * 
         * @param locationName
         *        Name of the location that is associated with the CIDR collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationName(String locationName);

        /**
         * <p>
         * CIDR collection change action.
         * </p>
         * 
         * @param action
         *        CIDR collection change action.
         * @see CidrCollectionChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CidrCollectionChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * CIDR collection change action.
         * </p>
         * 
         * @param action
         *        CIDR collection change action.
         * @see CidrCollectionChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CidrCollectionChangeAction
         */
        Builder action(CidrCollectionChangeAction action);

        /**
         * <p>
         * List of CIDR blocks.
         * </p>
         * 
         * @param cidrList
         *        List of CIDR blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrList(Collection<String> cidrList);

        /**
         * <p>
         * List of CIDR blocks.
         * </p>
         * 
         * @param cidrList
         *        List of CIDR blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrList(String... cidrList);
    }

    static final class BuilderImpl implements Builder {
        private String locationName;

        private String action;

        private List<String> cidrList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CidrCollectionChange model) {
            locationName(model.locationName);
            action(model.action);
            cidrList(model.cidrList);
        }

        public final String getLocationName() {
            return locationName;
        }

        public final void setLocationName(String locationName) {
            this.locationName = locationName;
        }

        @Override
        public final Builder locationName(String locationName) {
            this.locationName = locationName;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(CidrCollectionChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Collection<String> getCidrList() {
            if (cidrList instanceof SdkAutoConstructList) {
                return null;
            }
            return cidrList;
        }

        public final void setCidrList(Collection<String> cidrList) {
            this.cidrList = CidrListCopier.copy(cidrList);
        }

        @Override
        public final Builder cidrList(Collection<String> cidrList) {
            this.cidrList = CidrListCopier.copy(cidrList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrList(String... cidrList) {
            cidrList(Arrays.asList(cidrList));
            return this;
        }

        @Override
        public CidrCollectionChange build() {
            return new CidrCollectionChange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
