/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.AcceleratedRecoveryStatus;
import software.amazon.awssdk.services.route53.model.HostedZoneFailureReasons;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HostedZoneFeatures
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HostedZoneFeatures> {
    private static final SdkField<String> ACCELERATED_RECOVERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceleratedRecoveryStatus").getter(HostedZoneFeatures.getter(HostedZoneFeatures::acceleratedRecoveryStatusAsString)).setter(HostedZoneFeatures.setter(Builder::acceleratedRecoveryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratedRecoveryStatus").unmarshallLocationName("AcceleratedRecoveryStatus").build()}).build();
    private static final SdkField<HostedZoneFailureReasons> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureReasons").getter(HostedZoneFeatures.getter(HostedZoneFeatures::failureReasons)).setter(HostedZoneFeatures.setter(Builder::failureReasons)).constructor(HostedZoneFailureReasons::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReasons").unmarshallLocationName("FailureReasons").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATED_RECOVERY_STATUS_FIELD, FAILURE_REASONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HostedZoneFeatures.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String acceleratedRecoveryStatus;
    private final HostedZoneFailureReasons failureReasons;

    private HostedZoneFeatures(BuilderImpl builder) {
        this.acceleratedRecoveryStatus = builder.acceleratedRecoveryStatus;
        this.failureReasons = builder.failureReasons;
    }

    public final AcceleratedRecoveryStatus acceleratedRecoveryStatus() {
        return AcceleratedRecoveryStatus.fromValue(this.acceleratedRecoveryStatus);
    }

    public final String acceleratedRecoveryStatusAsString() {
        return this.acceleratedRecoveryStatus;
    }

    public final HostedZoneFailureReasons failureReasons() {
        return this.failureReasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratedRecoveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReasons());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedZoneFeatures)) {
            return false;
        }
        HostedZoneFeatures other = (HostedZoneFeatures)obj;
        return Objects.equals(this.acceleratedRecoveryStatusAsString(), other.acceleratedRecoveryStatusAsString()) && Objects.equals(this.failureReasons(), other.failureReasons());
    }

    public final String toString() {
        return ToString.builder((String)"HostedZoneFeatures").add("AcceleratedRecoveryStatus", (Object)this.acceleratedRecoveryStatusAsString()).add("FailureReasons", (Object)this.failureReasons()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceleratedRecoveryStatus": {
                return Optional.ofNullable(clazz.cast(this.acceleratedRecoveryStatusAsString()));
            }
            case "FailureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AcceleratedRecoveryStatus", ACCELERATED_RECOVERY_STATUS_FIELD);
        map.put("FailureReasons", FAILURE_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HostedZoneFeatures, T> g) {
        return obj -> g.apply((HostedZoneFeatures)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String acceleratedRecoveryStatus;
        private HostedZoneFailureReasons failureReasons;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedZoneFeatures model) {
            this.acceleratedRecoveryStatus(model.acceleratedRecoveryStatus);
            this.failureReasons(model.failureReasons);
        }

        public final String getAcceleratedRecoveryStatus() {
            return this.acceleratedRecoveryStatus;
        }

        public final void setAcceleratedRecoveryStatus(String acceleratedRecoveryStatus) {
            this.acceleratedRecoveryStatus = acceleratedRecoveryStatus;
        }

        @Override
        public final Builder acceleratedRecoveryStatus(String acceleratedRecoveryStatus) {
            this.acceleratedRecoveryStatus = acceleratedRecoveryStatus;
            return this;
        }

        @Override
        public final Builder acceleratedRecoveryStatus(AcceleratedRecoveryStatus acceleratedRecoveryStatus) {
            this.acceleratedRecoveryStatus(acceleratedRecoveryStatus == null ? null : acceleratedRecoveryStatus.toString());
            return this;
        }

        public final HostedZoneFailureReasons.Builder getFailureReasons() {
            return this.failureReasons != null ? this.failureReasons.toBuilder() : null;
        }

        public final void setFailureReasons(HostedZoneFailureReasons.BuilderImpl failureReasons) {
            this.failureReasons = failureReasons != null ? failureReasons.build() : null;
        }

        @Override
        public final Builder failureReasons(HostedZoneFailureReasons failureReasons) {
            this.failureReasons = failureReasons;
            return this;
        }

        public HostedZoneFeatures build() {
            return new HostedZoneFeatures(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HostedZoneFeatures> {
        public Builder acceleratedRecoveryStatus(String var1);

        public Builder acceleratedRecoveryStatus(AcceleratedRecoveryStatus var1);

        public Builder failureReasons(HostedZoneFailureReasons var1);

        default public Builder failureReasons(Consumer<HostedZoneFailureReasons.Builder> failureReasons) {
            return this.failureReasons((HostedZoneFailureReasons)((HostedZoneFailureReasons.Builder)HostedZoneFailureReasons.builder().applyMutation(failureReasons)).build());
        }
    }
}

