/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.services.route53.model.VPCRegion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHostedZonesByVpcRequest
extends Route53Request
implements ToCopyableBuilder<Builder, ListHostedZonesByVpcRequest> {
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCId").getter(ListHostedZonesByVpcRequest.getter(ListHostedZonesByVpcRequest::vpcId)).setter(ListHostedZonesByVpcRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("vpcid").unmarshallLocationName("vpcid").build()}).build();
    private static final SdkField<String> VPC_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCRegion").getter(ListHostedZonesByVpcRequest.getter(ListHostedZonesByVpcRequest::vpcRegionAsString)).setter(ListHostedZonesByVpcRequest.setter(Builder::vpcRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("vpcregion").unmarshallLocationName("vpcregion").build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxItems").getter(ListHostedZonesByVpcRequest.getter(ListHostedZonesByVpcRequest::maxItems)).setter(ListHostedZonesByVpcRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxitems").unmarshallLocationName("maxitems").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListHostedZonesByVpcRequest.getter(ListHostedZonesByVpcRequest::nextToken)).setter(ListHostedZonesByVpcRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nexttoken").unmarshallLocationName("nexttoken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ID_FIELD, VPC_REGION_FIELD, MAX_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListHostedZonesByVpcRequest.memberNameToFieldInitializer();
    private final String vpcId;
    private final String vpcRegion;
    private final String maxItems;
    private final String nextToken;

    private ListHostedZonesByVpcRequest(BuilderImpl builder) {
        super(builder);
        this.vpcId = builder.vpcId;
        this.vpcRegion = builder.vpcRegion;
        this.maxItems = builder.maxItems;
        this.nextToken = builder.nextToken;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final VPCRegion vpcRegion() {
        return VPCRegion.fromValue(this.vpcRegion);
    }

    public final String vpcRegionAsString() {
        return this.vpcRegion;
    }

    public final String maxItems() {
        return this.maxItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcRegionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesByVpcRequest)) {
            return false;
        }
        ListHostedZonesByVpcRequest other = (ListHostedZonesByVpcRequest)((Object)obj);
        return Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.vpcRegionAsString(), other.vpcRegionAsString()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListHostedZonesByVpcRequest").add("VPCId", (Object)this.vpcId()).add("VPCRegion", (Object)this.vpcRegionAsString()).add("MaxItems", (Object)this.maxItems()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VPCId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "VPCRegion": {
                return Optional.ofNullable(clazz.cast(this.vpcRegionAsString()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("vpcid", VPC_ID_FIELD);
        map.put("vpcregion", VPC_REGION_FIELD);
        map.put("maxitems", MAX_ITEMS_FIELD);
        map.put("nexttoken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListHostedZonesByVpcRequest, T> g) {
        return obj -> g.apply((ListHostedZonesByVpcRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String vpcId;
        private String vpcRegion;
        private String maxItems;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesByVpcRequest model) {
            super(model);
            this.vpcId(model.vpcId);
            this.vpcRegion(model.vpcRegion);
            this.maxItems(model.maxItems);
            this.nextToken(model.nextToken);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getVpcRegion() {
            return this.vpcRegion;
        }

        public final void setVpcRegion(String vpcRegion) {
            this.vpcRegion = vpcRegion;
        }

        @Override
        public final Builder vpcRegion(String vpcRegion) {
            this.vpcRegion = vpcRegion;
            return this;
        }

        @Override
        public final Builder vpcRegion(VPCRegion vpcRegion) {
            this.vpcRegion(vpcRegion == null ? null : vpcRegion.toString());
            return this;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListHostedZonesByVpcRequest build() {
            return new ListHostedZonesByVpcRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHostedZonesByVpcRequest> {
        public Builder vpcId(String var1);

        public Builder vpcRegion(String var1);

        public Builder vpcRegion(VPCRegion var1);

        public Builder maxItems(String var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

