/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKeySigningKeyResponse extends Route53Response implements
        ToCopyableBuilder<CreateKeySigningKeyResponse.Builder, CreateKeySigningKeyResponse> {
    private static final SdkField<ChangeInfo> CHANGE_INFO_FIELD = SdkField
            .<ChangeInfo> builder(MarshallingType.SDK_POJO)
            .memberName("ChangeInfo")
            .getter(getter(CreateKeySigningKeyResponse::changeInfo))
            .setter(setter(Builder::changeInfo))
            .constructor(ChangeInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeInfo")
                    .unmarshallLocationName("ChangeInfo").build()).build();

    private static final SdkField<KeySigningKey> KEY_SIGNING_KEY_FIELD = SdkField
            .<KeySigningKey> builder(MarshallingType.SDK_POJO)
            .memberName("KeySigningKey")
            .getter(getter(CreateKeySigningKeyResponse::keySigningKey))
            .setter(setter(Builder::keySigningKey))
            .constructor(KeySigningKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySigningKey")
                    .unmarshallLocationName("KeySigningKey").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Location")
            .getter(getter(CreateKeySigningKeyResponse::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_INFO_FIELD,
            KEY_SIGNING_KEY_FIELD, LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ChangeInfo changeInfo;

    private final KeySigningKey keySigningKey;

    private final String location;

    private CreateKeySigningKeyResponse(BuilderImpl builder) {
        super(builder);
        this.changeInfo = builder.changeInfo;
        this.keySigningKey = builder.keySigningKey;
        this.location = builder.location;
    }

    /**
     * Returns the value of the ChangeInfo property for this object.
     * 
     * @return The value of the ChangeInfo property for this object.
     */
    public final ChangeInfo changeInfo() {
        return changeInfo;
    }

    /**
     * <p>
     * The key-signing key (KSK) that the request creates.
     * </p>
     * 
     * @return The key-signing key (KSK) that the request creates.
     */
    public final KeySigningKey keySigningKey() {
        return keySigningKey;
    }

    /**
     * <p>
     * The unique URL representing the new key-signing key (KSK).
     * </p>
     * 
     * @return The unique URL representing the new key-signing key (KSK).
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(changeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(keySigningKey());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeySigningKeyResponse)) {
            return false;
        }
        CreateKeySigningKeyResponse other = (CreateKeySigningKeyResponse) obj;
        return Objects.equals(changeInfo(), other.changeInfo()) && Objects.equals(keySigningKey(), other.keySigningKey())
                && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateKeySigningKeyResponse").add("ChangeInfo", changeInfo())
                .add("KeySigningKey", keySigningKey()).add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeInfo":
            return Optional.ofNullable(clazz.cast(changeInfo()));
        case "KeySigningKey":
            return Optional.ofNullable(clazz.cast(keySigningKey()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChangeInfo", CHANGE_INFO_FIELD);
        map.put("KeySigningKey", KEY_SIGNING_KEY_FIELD);
        map.put("Location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateKeySigningKeyResponse, T> g) {
        return obj -> g.apply((CreateKeySigningKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateKeySigningKeyResponse> {
        /**
         * Sets the value of the ChangeInfo property for this object.
         *
         * @param changeInfo
         *        The new value for the ChangeInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeInfo(ChangeInfo changeInfo);

        /**
         * Sets the value of the ChangeInfo property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ChangeInfo.Builder} avoiding the need to
         * create one manually via {@link ChangeInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChangeInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #changeInfo(ChangeInfo)}.
         * 
         * @param changeInfo
         *        a consumer that will call methods on {@link ChangeInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeInfo(ChangeInfo)
         */
        default Builder changeInfo(Consumer<ChangeInfo.Builder> changeInfo) {
            return changeInfo(ChangeInfo.builder().applyMutation(changeInfo).build());
        }

        /**
         * <p>
         * The key-signing key (KSK) that the request creates.
         * </p>
         * 
         * @param keySigningKey
         *        The key-signing key (KSK) that the request creates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySigningKey(KeySigningKey keySigningKey);

        /**
         * <p>
         * The key-signing key (KSK) that the request creates.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeySigningKey.Builder} avoiding the need
         * to create one manually via {@link KeySigningKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeySigningKey.Builder#build()} is called immediately and its
         * result is passed to {@link #keySigningKey(KeySigningKey)}.
         * 
         * @param keySigningKey
         *        a consumer that will call methods on {@link KeySigningKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keySigningKey(KeySigningKey)
         */
        default Builder keySigningKey(Consumer<KeySigningKey.Builder> keySigningKey) {
            return keySigningKey(KeySigningKey.builder().applyMutation(keySigningKey).build());
        }

        /**
         * <p>
         * The unique URL representing the new key-signing key (KSK).
         * </p>
         * 
         * @param location
         *        The unique URL representing the new key-signing key (KSK).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private ChangeInfo changeInfo;

        private KeySigningKey keySigningKey;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeySigningKeyResponse model) {
            super(model);
            changeInfo(model.changeInfo);
            keySigningKey(model.keySigningKey);
            location(model.location);
        }

        public final ChangeInfo.Builder getChangeInfo() {
            return changeInfo != null ? changeInfo.toBuilder() : null;
        }

        public final void setChangeInfo(ChangeInfo.BuilderImpl changeInfo) {
            this.changeInfo = changeInfo != null ? changeInfo.build() : null;
        }

        @Override
        public final Builder changeInfo(ChangeInfo changeInfo) {
            this.changeInfo = changeInfo;
            return this;
        }

        public final KeySigningKey.Builder getKeySigningKey() {
            return keySigningKey != null ? keySigningKey.toBuilder() : null;
        }

        public final void setKeySigningKey(KeySigningKey.BuilderImpl keySigningKey) {
            this.keySigningKey = keySigningKey != null ? keySigningKey.build() : null;
        }

        @Override
        public final Builder keySigningKey(KeySigningKey keySigningKey) {
            this.keySigningKey = keySigningKey;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public CreateKeySigningKeyResponse build() {
            return new CreateKeySigningKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
