/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RRType {
    SOA("SOA"),
    A("A"),
    TXT("TXT"),
    NS("NS"),
    CNAME("CNAME"),
    MX("MX"),
    NAPTR("NAPTR"),
    PTR("PTR"),
    SRV("SRV"),
    SPF("SPF"),
    AAAA("AAAA"),
    CAA("CAA"),
    DS("DS"),
    TLSA("TLSA"),
    SSHFP("SSHFP"),
    SVCB("SVCB"),
    HTTPS("HTTPS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RRType> VALUE_MAP;
    private final String value;

    private RRType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RRType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RRType> knownValues() {
        EnumSet<RRType> knownValues = EnumSet.allOf(RRType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RRType.class, RRType::toString);
    }
}

