/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeCidrCollectionRequest extends Route53Request implements
        ToCopyableBuilder<ChangeCidrCollectionRequest.Builder, ChangeCidrCollectionRequest> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(ChangeCidrCollectionRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CidrCollectionId")
                    .unmarshallLocationName("CidrCollectionId").build()).build();

    private static final SdkField<Long> COLLECTION_VERSION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("CollectionVersion")
            .getter(getter(ChangeCidrCollectionRequest::collectionVersion))
            .setter(setter(Builder::collectionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionVersion")
                    .unmarshallLocationName("CollectionVersion").build()).build();

    private static final SdkField<List<CidrCollectionChange>> CHANGES_FIELD = SdkField
            .<List<CidrCollectionChange>> builder(MarshallingType.LIST)
            .memberName("Changes")
            .getter(getter(ChangeCidrCollectionRequest::changes))
            .setter(setter(Builder::changes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Changes")
                    .unmarshallLocationName("Changes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CidrCollectionChange> builder(MarshallingType.SDK_POJO)
                                            .constructor(CidrCollectionChange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            COLLECTION_VERSION_FIELD, CHANGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final Long collectionVersion;

    private final List<CidrCollectionChange> changes;

    private ChangeCidrCollectionRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.collectionVersion = builder.collectionVersion;
        this.changes = builder.changes;
    }

    /**
     * <p>
     * The UUID of the CIDR collection to update.
     * </p>
     * 
     * @return The UUID of the CIDR collection to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A sequential counter that Amazon Route 53 sets to 1 when you create a collection and increments it by 1 each time
     * you update the collection.
     * </p>
     * <p>
     * We recommend that you use <code>ListCidrCollection</code> to get the current value of
     * <code>CollectionVersion</code> for the collection that you want to update, and then include that value with the
     * change request. This prevents Route 53 from overwriting an intervening update:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the value in the request matches the value of <code>CollectionVersion</code> in the collection, Route 53
     * updates the collection.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value of <code>CollectionVersion</code> in the collection is greater than the value in the request, the
     * collection was changed after you got the version number. Route 53 does not update the collection, and it returns
     * a <code>CidrCollectionVersionMismatch</code> error.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A sequential counter that Amazon Route 53 sets to 1 when you create a collection and increments it by 1
     *         each time you update the collection.</p>
     *         <p>
     *         We recommend that you use <code>ListCidrCollection</code> to get the current value of
     *         <code>CollectionVersion</code> for the collection that you want to update, and then include that value
     *         with the change request. This prevents Route 53 from overwriting an intervening update:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the value in the request matches the value of <code>CollectionVersion</code> in the collection,
     *         Route 53 updates the collection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the value of <code>CollectionVersion</code> in the collection is greater than the value in the
     *         request, the collection was changed after you got the version number. Route 53 does not update the
     *         collection, and it returns a <code>CidrCollectionVersionMismatch</code> error.
     *         </p>
     *         </li>
     */
    public final Long collectionVersion() {
        return collectionVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Changes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChanges() {
        return changes != null && !(changes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about changes to a CIDR collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChanges} method.
     * </p>
     * 
     * @return Information about changes to a CIDR collection.
     */
    public final List<CidrCollectionChange> changes() {
        return changes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(collectionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasChanges() ? changes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeCidrCollectionRequest)) {
            return false;
        }
        ChangeCidrCollectionRequest other = (ChangeCidrCollectionRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(collectionVersion(), other.collectionVersion())
                && hasChanges() == other.hasChanges() && Objects.equals(changes(), other.changes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeCidrCollectionRequest").add("Id", id()).add("CollectionVersion", collectionVersion())
                .add("Changes", hasChanges() ? changes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "CollectionVersion":
            return Optional.ofNullable(clazz.cast(collectionVersion()));
        case "Changes":
            return Optional.ofNullable(clazz.cast(changes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CidrCollectionId", ID_FIELD);
        map.put("CollectionVersion", COLLECTION_VERSION_FIELD);
        map.put("Changes", CHANGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeCidrCollectionRequest, T> g) {
        return obj -> g.apply((ChangeCidrCollectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, ChangeCidrCollectionRequest> {
        /**
         * <p>
         * The UUID of the CIDR collection to update.
         * </p>
         * 
         * @param id
         *        The UUID of the CIDR collection to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A sequential counter that Amazon Route 53 sets to 1 when you create a collection and increments it by 1 each
         * time you update the collection.
         * </p>
         * <p>
         * We recommend that you use <code>ListCidrCollection</code> to get the current value of
         * <code>CollectionVersion</code> for the collection that you want to update, and then include that value with
         * the change request. This prevents Route 53 from overwriting an intervening update:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the value in the request matches the value of <code>CollectionVersion</code> in the collection, Route 53
         * updates the collection.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the value of <code>CollectionVersion</code> in the collection is greater than the value in the request,
         * the collection was changed after you got the version number. Route 53 does not update the collection, and it
         * returns a <code>CidrCollectionVersionMismatch</code> error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param collectionVersion
         *        A sequential counter that Amazon Route 53 sets to 1 when you create a collection and increments it by
         *        1 each time you update the collection.</p>
         *        <p>
         *        We recommend that you use <code>ListCidrCollection</code> to get the current value of
         *        <code>CollectionVersion</code> for the collection that you want to update, and then include that value
         *        with the change request. This prevents Route 53 from overwriting an intervening update:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the value in the request matches the value of <code>CollectionVersion</code> in the collection,
         *        Route 53 updates the collection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the value of <code>CollectionVersion</code> in the collection is greater than the value in the
         *        request, the collection was changed after you got the version number. Route 53 does not update the
         *        collection, and it returns a <code>CidrCollectionVersionMismatch</code> error.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionVersion(Long collectionVersion);

        /**
         * <p>
         * Information about changes to a CIDR collection.
         * </p>
         * 
         * @param changes
         *        Information about changes to a CIDR collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changes(Collection<CidrCollectionChange> changes);

        /**
         * <p>
         * Information about changes to a CIDR collection.
         * </p>
         * 
         * @param changes
         *        Information about changes to a CIDR collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changes(CidrCollectionChange... changes);

        /**
         * <p>
         * Information about changes to a CIDR collection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53.model.CidrCollectionChange.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.route53.model.CidrCollectionChange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53.model.CidrCollectionChange.Builder#build()} is called
         * immediately and its result is passed to {@link #changes(List<CidrCollectionChange>)}.
         * 
         * @param changes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53.model.CidrCollectionChange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changes(java.util.Collection<CidrCollectionChange>)
         */
        Builder changes(Consumer<CidrCollectionChange.Builder>... changes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String id;

        private Long collectionVersion;

        private List<CidrCollectionChange> changes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeCidrCollectionRequest model) {
            super(model);
            id(model.id);
            collectionVersion(model.collectionVersion);
            changes(model.changes);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Long getCollectionVersion() {
            return collectionVersion;
        }

        public final void setCollectionVersion(Long collectionVersion) {
            this.collectionVersion = collectionVersion;
        }

        @Override
        public final Builder collectionVersion(Long collectionVersion) {
            this.collectionVersion = collectionVersion;
            return this;
        }

        public final List<CidrCollectionChange.Builder> getChanges() {
            List<CidrCollectionChange.Builder> result = CidrCollectionChangesCopier.copyToBuilder(this.changes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChanges(Collection<CidrCollectionChange.BuilderImpl> changes) {
            this.changes = CidrCollectionChangesCopier.copyFromBuilder(changes);
        }

        @Override
        public final Builder changes(Collection<CidrCollectionChange> changes) {
            this.changes = CidrCollectionChangesCopier.copy(changes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(CidrCollectionChange... changes) {
            changes(Arrays.asList(changes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Consumer<CidrCollectionChange.Builder>... changes) {
            changes(Stream.of(changes).map(c -> CidrCollectionChange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChangeCidrCollectionRequest build() {
            return new ChangeCidrCollectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
