/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.route53.Route53AsyncClient;
import software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceResponse;
import software.amazon.awssdk.services.route53.model.ConcurrentModificationException;
import software.amazon.awssdk.services.route53.model.ConflictingDomainExistsException;
import software.amazon.awssdk.services.route53.model.ConflictingTypesException;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionResponse;
import software.amazon.awssdk.services.route53.model.CreateVpcAssociationAuthorizationRequest;
import software.amazon.awssdk.services.route53.model.CreateVpcAssociationAuthorizationResponse;
import software.amazon.awssdk.services.route53.model.DelegationSetAlreadyCreatedException;
import software.amazon.awssdk.services.route53.model.DelegationSetAlreadyReusableException;
import software.amazon.awssdk.services.route53.model.DelegationSetInUseException;
import software.amazon.awssdk.services.route53.model.DelegationSetNotAvailableException;
import software.amazon.awssdk.services.route53.model.DelegationSetNotReusableException;
import software.amazon.awssdk.services.route53.model.DeleteHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.DeleteHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationRequest;
import software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationResponse;
import software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetAccountLimitRequest;
import software.amazon.awssdk.services.route53.model.GetAccountLimitResponse;
import software.amazon.awssdk.services.route53.model.GetChangeRequest;
import software.amazon.awssdk.services.route53.model.GetChangeResponse;
import software.amazon.awssdk.services.route53.model.GetCheckerIpRangesRequest;
import software.amazon.awssdk.services.route53.model.GetCheckerIpRangesResponse;
import software.amazon.awssdk.services.route53.model.GetGeoLocationRequest;
import software.amazon.awssdk.services.route53.model.GetGeoLocationResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckCountRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckCountResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckStatusRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckStatusResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneCountRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneCountResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneLimitRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneLimitResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitRequest;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitResponse;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.HealthCheckAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.HealthCheckVersionMismatchException;
import software.amazon.awssdk.services.route53.model.HostedZoneAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.HostedZoneNotEmptyException;
import software.amazon.awssdk.services.route53.model.HostedZoneNotFoundException;
import software.amazon.awssdk.services.route53.model.HostedZoneNotPrivateException;
import software.amazon.awssdk.services.route53.model.IncompatibleVersionException;
import software.amazon.awssdk.services.route53.model.InsufficientCloudWatchLogsResourcePolicyException;
import software.amazon.awssdk.services.route53.model.InvalidArgumentException;
import software.amazon.awssdk.services.route53.model.InvalidChangeBatchException;
import software.amazon.awssdk.services.route53.model.InvalidDomainNameException;
import software.amazon.awssdk.services.route53.model.InvalidInputException;
import software.amazon.awssdk.services.route53.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.route53.model.InvalidTrafficPolicyDocumentException;
import software.amazon.awssdk.services.route53.model.InvalidVpcIdException;
import software.amazon.awssdk.services.route53.model.LastVpcAssociationException;
import software.amazon.awssdk.services.route53.model.LimitsExceededException;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsResponse;
import software.amazon.awssdk.services.route53.model.ListHealthChecksRequest;
import software.amazon.awssdk.services.route53.model.ListHealthChecksResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesResponse;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsRequest;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsResponse;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53.model.ListTagsForResourcesRequest;
import software.amazon.awssdk.services.route53.model.ListTagsForResourcesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsResponse;
import software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsRequest;
import software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsResponse;
import software.amazon.awssdk.services.route53.model.NoSuchChangeException;
import software.amazon.awssdk.services.route53.model.NoSuchCloudWatchLogsLogGroupException;
import software.amazon.awssdk.services.route53.model.NoSuchDelegationSetException;
import software.amazon.awssdk.services.route53.model.NoSuchGeoLocationException;
import software.amazon.awssdk.services.route53.model.NoSuchHealthCheckException;
import software.amazon.awssdk.services.route53.model.NoSuchHostedZoneException;
import software.amazon.awssdk.services.route53.model.NoSuchQueryLoggingConfigException;
import software.amazon.awssdk.services.route53.model.NoSuchTrafficPolicyException;
import software.amazon.awssdk.services.route53.model.NoSuchTrafficPolicyInstanceException;
import software.amazon.awssdk.services.route53.model.NotAuthorizedException;
import software.amazon.awssdk.services.route53.model.PriorRequestNotCompleteException;
import software.amazon.awssdk.services.route53.model.PublicZoneVpcAssociationException;
import software.amazon.awssdk.services.route53.model.QueryLoggingConfigAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.Route53Exception;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.services.route53.model.TestDnsAnswerRequest;
import software.amazon.awssdk.services.route53.model.TestDnsAnswerResponse;
import software.amazon.awssdk.services.route53.model.ThrottlingException;
import software.amazon.awssdk.services.route53.model.TooManyHealthChecksException;
import software.amazon.awssdk.services.route53.model.TooManyHostedZonesException;
import software.amazon.awssdk.services.route53.model.TooManyTrafficPoliciesException;
import software.amazon.awssdk.services.route53.model.TooManyTrafficPolicyInstancesException;
import software.amazon.awssdk.services.route53.model.TooManyTrafficPolicyVersionsForCurrentPolicyException;
import software.amazon.awssdk.services.route53.model.TooManyVpcAssociationAuthorizationsException;
import software.amazon.awssdk.services.route53.model.TrafficPolicyAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.TrafficPolicyInUseException;
import software.amazon.awssdk.services.route53.model.TrafficPolicyInstanceAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.UpdateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentRequest;
import software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentResponse;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentRequest;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentResponse;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.VpcAssociationAuthorizationNotFoundException;
import software.amazon.awssdk.services.route53.model.VpcAssociationNotFoundException;
import software.amazon.awssdk.services.route53.paginators.ListHealthChecksPublisher;
import software.amazon.awssdk.services.route53.paginators.ListHostedZonesPublisher;
import software.amazon.awssdk.services.route53.paginators.ListResourceRecordSetsPublisher;
import software.amazon.awssdk.services.route53.transform.AssociateVpcWithHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ChangeResourceRecordSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ChangeTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateQueryLoggingConfigRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateVpcAssociationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteQueryLoggingConfigRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteVpcAssociationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DisassociateVpcFromHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetAccountLimitRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetChangeRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetCheckerIpRangesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetGeoLocationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckLastFailureReasonRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckStatusRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneLimitRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetQueryLoggingConfigRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetReusableDelegationSetLimitRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyInstanceCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListGeoLocationsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHealthChecksRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesByNameRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListQueryLoggingConfigsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListResourceRecordSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListReusableDelegationSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTagsForResourcesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPoliciesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesByHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesByPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyVersionsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListVpcAssociationAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.TestDnsAnswerRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateHostedZoneCommentRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateTrafficPolicyCommentRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultRoute53AsyncClient
implements Route53AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultRoute53AsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsXmlProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRoute53AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "route53";
    }

    @Override
    public CompletableFuture<AssociateVpcWithHostedZoneResponse> associateVPCWithHostedZone(AssociateVpcWithHostedZoneRequest associateVpcWithHostedZoneRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AssociateVpcWithHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateVPCWithHostedZone").withMarshaller((Marshaller)new AssociateVpcWithHostedZoneRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateVpcWithHostedZoneRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ChangeResourceRecordSetsResponse> changeResourceRecordSets(ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ChangeResourceRecordSetsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ChangeResourceRecordSets").withMarshaller((Marshaller)new ChangeResourceRecordSetsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)changeResourceRecordSetsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ChangeTagsForResourceResponse> changeTagsForResource(ChangeTagsForResourceRequest changeTagsForResourceRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ChangeTagsForResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ChangeTagsForResource").withMarshaller((Marshaller)new ChangeTagsForResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)changeTagsForResourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateHealthCheckResponse> createHealthCheck(CreateHealthCheckRequest createHealthCheckRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHealthCheck").withMarshaller((Marshaller)new CreateHealthCheckRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHealthCheckRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateHostedZoneResponse> createHostedZone(CreateHostedZoneRequest createHostedZoneRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHostedZone").withMarshaller((Marshaller)new CreateHostedZoneRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHostedZoneRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateQueryLoggingConfigResponse> createQueryLoggingConfig(CreateQueryLoggingConfigRequest createQueryLoggingConfigRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateQueryLoggingConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateQueryLoggingConfig").withMarshaller((Marshaller)new CreateQueryLoggingConfigRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createQueryLoggingConfigRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateReusableDelegationSetResponse> createReusableDelegationSet(CreateReusableDelegationSetRequest createReusableDelegationSetRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateReusableDelegationSetResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReusableDelegationSet").withMarshaller((Marshaller)new CreateReusableDelegationSetRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReusableDelegationSetRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTrafficPolicyResponse> createTrafficPolicy(CreateTrafficPolicyRequest createTrafficPolicyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateTrafficPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrafficPolicy").withMarshaller((Marshaller)new CreateTrafficPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTrafficPolicyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTrafficPolicyInstanceResponse> createTrafficPolicyInstance(CreateTrafficPolicyInstanceRequest createTrafficPolicyInstanceRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateTrafficPolicyInstanceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrafficPolicyInstance").withMarshaller((Marshaller)new CreateTrafficPolicyInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTrafficPolicyInstanceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTrafficPolicyVersionResponse> createTrafficPolicyVersion(CreateTrafficPolicyVersionRequest createTrafficPolicyVersionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateTrafficPolicyVersionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrafficPolicyVersion").withMarshaller((Marshaller)new CreateTrafficPolicyVersionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTrafficPolicyVersionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateVpcAssociationAuthorizationResponse> createVPCAssociationAuthorization(CreateVpcAssociationAuthorizationRequest createVpcAssociationAuthorizationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateVpcAssociationAuthorizationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVPCAssociationAuthorization").withMarshaller((Marshaller)new CreateVpcAssociationAuthorizationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVpcAssociationAuthorizationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteHealthCheckResponse> deleteHealthCheck(DeleteHealthCheckRequest deleteHealthCheckRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHealthCheck").withMarshaller((Marshaller)new DeleteHealthCheckRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteHealthCheckRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteHostedZoneResponse> deleteHostedZone(DeleteHostedZoneRequest deleteHostedZoneRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHostedZone").withMarshaller((Marshaller)new DeleteHostedZoneRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteHostedZoneRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteQueryLoggingConfigResponse> deleteQueryLoggingConfig(DeleteQueryLoggingConfigRequest deleteQueryLoggingConfigRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteQueryLoggingConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteQueryLoggingConfig").withMarshaller((Marshaller)new DeleteQueryLoggingConfigRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteQueryLoggingConfigRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteReusableDelegationSetResponse> deleteReusableDelegationSet(DeleteReusableDelegationSetRequest deleteReusableDelegationSetRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteReusableDelegationSetResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReusableDelegationSet").withMarshaller((Marshaller)new DeleteReusableDelegationSetRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReusableDelegationSetRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTrafficPolicyResponse> deleteTrafficPolicy(DeleteTrafficPolicyRequest deleteTrafficPolicyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteTrafficPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrafficPolicy").withMarshaller((Marshaller)new DeleteTrafficPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTrafficPolicyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTrafficPolicyInstanceResponse> deleteTrafficPolicyInstance(DeleteTrafficPolicyInstanceRequest deleteTrafficPolicyInstanceRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteTrafficPolicyInstanceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrafficPolicyInstance").withMarshaller((Marshaller)new DeleteTrafficPolicyInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTrafficPolicyInstanceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteVpcAssociationAuthorizationResponse> deleteVPCAssociationAuthorization(DeleteVpcAssociationAuthorizationRequest deleteVpcAssociationAuthorizationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteVpcAssociationAuthorizationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVPCAssociationAuthorization").withMarshaller((Marshaller)new DeleteVpcAssociationAuthorizationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVpcAssociationAuthorizationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateVpcFromHostedZoneResponse> disassociateVPCFromHostedZone(DisassociateVpcFromHostedZoneRequest disassociateVpcFromHostedZoneRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisassociateVpcFromHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateVPCFromHostedZone").withMarshaller((Marshaller)new DisassociateVpcFromHostedZoneRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateVpcFromHostedZoneRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccountLimitResponse> getAccountLimit(GetAccountLimitRequest getAccountLimitRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetAccountLimitResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccountLimit").withMarshaller((Marshaller)new GetAccountLimitRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAccountLimitRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetChangeResponse> getChange(GetChangeRequest getChangeRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetChangeResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetChange").withMarshaller((Marshaller)new GetChangeRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getChangeRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCheckerIpRangesResponse> getCheckerIpRanges(GetCheckerIpRangesRequest getCheckerIpRangesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetCheckerIpRangesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCheckerIpRanges").withMarshaller((Marshaller)new GetCheckerIpRangesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCheckerIpRangesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetGeoLocationResponse> getGeoLocation(GetGeoLocationRequest getGeoLocationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetGeoLocationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGeoLocation").withMarshaller((Marshaller)new GetGeoLocationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGeoLocationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetHealthCheckResponse> getHealthCheck(GetHealthCheckRequest getHealthCheckRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHealthCheck").withMarshaller((Marshaller)new GetHealthCheckRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getHealthCheckRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetHealthCheckCountResponse> getHealthCheckCount(GetHealthCheckCountRequest getHealthCheckCountRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetHealthCheckCountResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHealthCheckCount").withMarshaller((Marshaller)new GetHealthCheckCountRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getHealthCheckCountRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetHealthCheckLastFailureReasonResponse> getHealthCheckLastFailureReason(GetHealthCheckLastFailureReasonRequest getHealthCheckLastFailureReasonRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetHealthCheckLastFailureReasonResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHealthCheckLastFailureReason").withMarshaller((Marshaller)new GetHealthCheckLastFailureReasonRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getHealthCheckLastFailureReasonRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetHealthCheckStatusResponse> getHealthCheckStatus(GetHealthCheckStatusRequest getHealthCheckStatusRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetHealthCheckStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHealthCheckStatus").withMarshaller((Marshaller)new GetHealthCheckStatusRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getHealthCheckStatusRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetHostedZoneResponse> getHostedZone(GetHostedZoneRequest getHostedZoneRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHostedZone").withMarshaller((Marshaller)new GetHostedZoneRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getHostedZoneRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetHostedZoneCountResponse> getHostedZoneCount(GetHostedZoneCountRequest getHostedZoneCountRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetHostedZoneCountResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHostedZoneCount").withMarshaller((Marshaller)new GetHostedZoneCountRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getHostedZoneCountRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetHostedZoneLimitResponse> getHostedZoneLimit(GetHostedZoneLimitRequest getHostedZoneLimitRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetHostedZoneLimitResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHostedZoneLimit").withMarshaller((Marshaller)new GetHostedZoneLimitRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getHostedZoneLimitRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetQueryLoggingConfigResponse> getQueryLoggingConfig(GetQueryLoggingConfigRequest getQueryLoggingConfigRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetQueryLoggingConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryLoggingConfig").withMarshaller((Marshaller)new GetQueryLoggingConfigRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQueryLoggingConfigRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReusableDelegationSetResponse> getReusableDelegationSet(GetReusableDelegationSetRequest getReusableDelegationSetRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetReusableDelegationSetResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReusableDelegationSet").withMarshaller((Marshaller)new GetReusableDelegationSetRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReusableDelegationSetRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReusableDelegationSetLimitResponse> getReusableDelegationSetLimit(GetReusableDelegationSetLimitRequest getReusableDelegationSetLimitRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetReusableDelegationSetLimitResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReusableDelegationSetLimit").withMarshaller((Marshaller)new GetReusableDelegationSetLimitRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReusableDelegationSetLimitRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTrafficPolicyResponse> getTrafficPolicy(GetTrafficPolicyRequest getTrafficPolicyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetTrafficPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrafficPolicy").withMarshaller((Marshaller)new GetTrafficPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTrafficPolicyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTrafficPolicyInstanceResponse> getTrafficPolicyInstance(GetTrafficPolicyInstanceRequest getTrafficPolicyInstanceRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetTrafficPolicyInstanceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrafficPolicyInstance").withMarshaller((Marshaller)new GetTrafficPolicyInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTrafficPolicyInstanceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTrafficPolicyInstanceCountResponse> getTrafficPolicyInstanceCount(GetTrafficPolicyInstanceCountRequest getTrafficPolicyInstanceCountRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetTrafficPolicyInstanceCountResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrafficPolicyInstanceCount").withMarshaller((Marshaller)new GetTrafficPolicyInstanceCountRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTrafficPolicyInstanceCountRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListGeoLocationsResponse> listGeoLocations(ListGeoLocationsRequest listGeoLocationsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListGeoLocationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGeoLocations").withMarshaller((Marshaller)new ListGeoLocationsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGeoLocationsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListHealthChecksResponse> listHealthChecks(ListHealthChecksRequest listHealthChecksRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListHealthChecksResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHealthChecks").withMarshaller((Marshaller)new ListHealthChecksRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHealthChecksRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListHealthChecksPublisher listHealthChecksPaginator(ListHealthChecksRequest listHealthChecksRequest) {
        return new ListHealthChecksPublisher(this, this.applyPaginatorUserAgent(listHealthChecksRequest));
    }

    @Override
    public CompletableFuture<ListHostedZonesResponse> listHostedZones(ListHostedZonesRequest listHostedZonesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListHostedZonesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHostedZones").withMarshaller((Marshaller)new ListHostedZonesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHostedZonesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListHostedZonesByNameResponse> listHostedZonesByName(ListHostedZonesByNameRequest listHostedZonesByNameRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListHostedZonesByNameResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHostedZonesByName").withMarshaller((Marshaller)new ListHostedZonesByNameRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHostedZonesByNameRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListHostedZonesPublisher listHostedZonesPaginator(ListHostedZonesRequest listHostedZonesRequest) {
        return new ListHostedZonesPublisher(this, this.applyPaginatorUserAgent(listHostedZonesRequest));
    }

    @Override
    public CompletableFuture<ListQueryLoggingConfigsResponse> listQueryLoggingConfigs(ListQueryLoggingConfigsRequest listQueryLoggingConfigsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListQueryLoggingConfigsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQueryLoggingConfigs").withMarshaller((Marshaller)new ListQueryLoggingConfigsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listQueryLoggingConfigsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListResourceRecordSetsResponse> listResourceRecordSets(ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListResourceRecordSetsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceRecordSets").withMarshaller((Marshaller)new ListResourceRecordSetsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourceRecordSetsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListResourceRecordSetsPublisher listResourceRecordSetsPaginator(ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        return new ListResourceRecordSetsPublisher(this, this.applyPaginatorUserAgent(listResourceRecordSetsRequest));
    }

    @Override
    public CompletableFuture<ListReusableDelegationSetsResponse> listReusableDelegationSets(ListReusableDelegationSetsRequest listReusableDelegationSetsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListReusableDelegationSetsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReusableDelegationSets").withMarshaller((Marshaller)new ListReusableDelegationSetsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listReusableDelegationSetsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourcesResponse> listTagsForResources(ListTagsForResourcesRequest listTagsForResourcesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourcesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResources").withMarshaller((Marshaller)new ListTagsForResourcesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourcesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTrafficPoliciesResponse> listTrafficPolicies(ListTrafficPoliciesRequest listTrafficPoliciesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTrafficPoliciesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrafficPolicies").withMarshaller((Marshaller)new ListTrafficPoliciesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTrafficPoliciesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTrafficPolicyInstancesResponse> listTrafficPolicyInstances(ListTrafficPolicyInstancesRequest listTrafficPolicyInstancesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTrafficPolicyInstancesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrafficPolicyInstances").withMarshaller((Marshaller)new ListTrafficPolicyInstancesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTrafficPolicyInstancesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTrafficPolicyInstancesByHostedZoneResponse> listTrafficPolicyInstancesByHostedZone(ListTrafficPolicyInstancesByHostedZoneRequest listTrafficPolicyInstancesByHostedZoneRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTrafficPolicyInstancesByHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrafficPolicyInstancesByHostedZone").withMarshaller((Marshaller)new ListTrafficPolicyInstancesByHostedZoneRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTrafficPolicyInstancesByHostedZoneRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTrafficPolicyInstancesByPolicyResponse> listTrafficPolicyInstancesByPolicy(ListTrafficPolicyInstancesByPolicyRequest listTrafficPolicyInstancesByPolicyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTrafficPolicyInstancesByPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrafficPolicyInstancesByPolicy").withMarshaller((Marshaller)new ListTrafficPolicyInstancesByPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTrafficPolicyInstancesByPolicyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTrafficPolicyVersionsResponse> listTrafficPolicyVersions(ListTrafficPolicyVersionsRequest listTrafficPolicyVersionsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTrafficPolicyVersionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrafficPolicyVersions").withMarshaller((Marshaller)new ListTrafficPolicyVersionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTrafficPolicyVersionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListVpcAssociationAuthorizationsResponse> listVPCAssociationAuthorizations(ListVpcAssociationAuthorizationsRequest listVpcAssociationAuthorizationsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListVpcAssociationAuthorizationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVPCAssociationAuthorizations").withMarshaller((Marshaller)new ListVpcAssociationAuthorizationsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listVpcAssociationAuthorizationsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TestDnsAnswerResponse> testDNSAnswer(TestDnsAnswerRequest testDnsAnswerRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TestDnsAnswerResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestDNSAnswer").withMarshaller((Marshaller)new TestDnsAnswerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testDnsAnswerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateHealthCheckResponse> updateHealthCheck(UpdateHealthCheckRequest updateHealthCheckRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateHealthCheck").withMarshaller((Marshaller)new UpdateHealthCheckRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateHealthCheckRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateHostedZoneCommentResponse> updateHostedZoneComment(UpdateHostedZoneCommentRequest updateHostedZoneCommentRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateHostedZoneCommentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateHostedZoneComment").withMarshaller((Marshaller)new UpdateHostedZoneCommentRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateHostedZoneCommentRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTrafficPolicyCommentResponse> updateTrafficPolicyComment(UpdateTrafficPolicyCommentRequest updateTrafficPolicyCommentRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateTrafficPolicyCommentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTrafficPolicyComment").withMarshaller((Marshaller)new UpdateTrafficPolicyCommentRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTrafficPolicyCommentRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTrafficPolicyInstanceResponse> updateTrafficPolicyInstance(UpdateTrafficPolicyInstanceRequest updateTrafficPolicyInstanceRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateTrafficPolicyInstanceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTrafficPolicyInstance").withMarshaller((Marshaller)new UpdateTrafficPolicyInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTrafficPolicyInstanceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModification").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTrafficPolicyVersionsForCurrentPolicy").exceptionBuilderSupplier(TooManyTrafficPolicyVersionsForCurrentPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncompatibleVersion").exceptionBuilderSupplier(IncompatibleVersionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("VPCAssociationAuthorizationNotFound").exceptionBuilderSupplier(VpcAssociationAuthorizationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchTrafficPolicy").exceptionBuilderSupplier(NoSuchTrafficPolicyException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTrafficPolicies").exceptionBuilderSupplier(TooManyTrafficPoliciesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegationSetAlreadyCreated").exceptionBuilderSupplier(DelegationSetAlreadyCreatedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchHostedZone").exceptionBuilderSupplier(NoSuchHostedZoneException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QueryLoggingConfigAlreadyExists").exceptionBuilderSupplier(QueryLoggingConfigAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HostedZoneNotPrivate").exceptionBuilderSupplier(HostedZoneNotPrivateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchGeoLocation").exceptionBuilderSupplier(NoSuchGeoLocationException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientCloudWatchLogsResourcePolicy").exceptionBuilderSupplier(InsufficientCloudWatchLogsResourcePolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HealthCheckVersionMismatch").exceptionBuilderSupplier(HealthCheckVersionMismatchException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PublicZoneVPCAssociation").exceptionBuilderSupplier(PublicZoneVpcAssociationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HealthCheckAlreadyExists").exceptionBuilderSupplier(HealthCheckAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchDelegationSet").exceptionBuilderSupplier(NoSuchDelegationSetException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotAuthorizedException").exceptionBuilderSupplier(NotAuthorizedException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("VPCAssociationNotFound").exceptionBuilderSupplier(VpcAssociationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyVPCAssociationAuthorizations").exceptionBuilderSupplier(TooManyVpcAssociationAuthorizationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidVPCId").exceptionBuilderSupplier(InvalidVpcIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTrafficPolicyInstances").exceptionBuilderSupplier(TooManyTrafficPolicyInstancesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPaginationToken").exceptionBuilderSupplier(InvalidPaginationTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegationSetNotAvailable").exceptionBuilderSupplier(DelegationSetNotAvailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchTrafficPolicyInstance").exceptionBuilderSupplier(NoSuchTrafficPolicyInstanceException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HostedZoneNotEmpty").exceptionBuilderSupplier(HostedZoneNotEmptyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDomainName").exceptionBuilderSupplier(InvalidDomainNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyHealthChecks").exceptionBuilderSupplier(TooManyHealthChecksException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidChangeBatch").exceptionBuilderSupplier(InvalidChangeBatchException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HostedZoneAlreadyExists").exceptionBuilderSupplier(HostedZoneAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTrafficPolicyDocument").exceptionBuilderSupplier(InvalidTrafficPolicyDocumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrafficPolicyAlreadyExists").exceptionBuilderSupplier(TrafficPolicyAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegationSetAlreadyReusable").exceptionBuilderSupplier(DelegationSetAlreadyReusableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrafficPolicyInUse").exceptionBuilderSupplier(TrafficPolicyInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyHostedZones").exceptionBuilderSupplier(TooManyHostedZonesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrafficPolicyInstanceAlreadyExists").exceptionBuilderSupplier(TrafficPolicyInstanceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchChange").exceptionBuilderSupplier(NoSuchChangeException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictingTypes").exceptionBuilderSupplier(ConflictingTypesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegationSetNotReusable").exceptionBuilderSupplier(DelegationSetNotReusableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PriorRequestNotComplete").exceptionBuilderSupplier(PriorRequestNotCompleteException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HostedZoneNotFound").exceptionBuilderSupplier(HostedZoneNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgument").exceptionBuilderSupplier(InvalidArgumentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInput").exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictingDomainExists").exceptionBuilderSupplier(ConflictingDomainExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegationSetInUse").exceptionBuilderSupplier(DelegationSetInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchQueryLoggingConfig").exceptionBuilderSupplier(NoSuchQueryLoggingConfigException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchHealthCheck").exceptionBuilderSupplier(NoSuchHealthCheckException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LastVPCAssociation").exceptionBuilderSupplier(LastVpcAssociationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchCloudWatchLogsLogGroup").exceptionBuilderSupplier(NoSuchCloudWatchLogsLogGroupException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitsExceeded").exceptionBuilderSupplier(LimitsExceededException::builder).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(Route53Exception::builder).build();
    }

    private <T extends Route53Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.3.0").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((Route53Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

