/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53.model.ListCidrLocationsRequest;
import software.amazon.awssdk.services.route53.model.ListCidrLocationsResponse;
import software.amazon.awssdk.services.route53.model.LocationSummary;

public class ListCidrLocationsIterable
implements SdkIterable<ListCidrLocationsResponse> {
    private final Route53Client client;
    private final ListCidrLocationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCidrLocationsIterable(Route53Client client, ListCidrLocationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCidrLocationsResponseFetcher();
    }

    public Iterator<ListCidrLocationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LocationSummary> cidrLocations() {
        Function<ListCidrLocationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cidrLocations() != null) {
                return response.cidrLocations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCidrLocationsResponseFetcher
    implements SyncPageFetcher<ListCidrLocationsResponse> {
        private ListCidrLocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCidrLocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCidrLocationsResponse nextPage(ListCidrLocationsResponse previousPage) {
            if (previousPage == null) {
                return ListCidrLocationsIterable.this.client.listCidrLocations(ListCidrLocationsIterable.this.firstRequest);
            }
            return ListCidrLocationsIterable.this.client.listCidrLocations((ListCidrLocationsRequest)((Object)ListCidrLocationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

