/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrafficPolicyInstancesByHostedZoneRequest
extends Route53Request
implements ToCopyableBuilder<Builder, ListTrafficPolicyInstancesByHostedZoneRequest> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(ListTrafficPolicyInstancesByHostedZoneRequest.getter(ListTrafficPolicyInstancesByHostedZoneRequest::hostedZoneId)).setter(ListTrafficPolicyInstancesByHostedZoneRequest.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("id").unmarshallLocationName("id").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_INSTANCE_NAME_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyInstanceNameMarker").getter(ListTrafficPolicyInstancesByHostedZoneRequest.getter(ListTrafficPolicyInstancesByHostedZoneRequest::trafficPolicyInstanceNameMarker)).setter(ListTrafficPolicyInstancesByHostedZoneRequest.setter(Builder::trafficPolicyInstanceNameMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("trafficpolicyinstancename").unmarshallLocationName("trafficpolicyinstancename").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_INSTANCE_TYPE_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyInstanceTypeMarker").getter(ListTrafficPolicyInstancesByHostedZoneRequest.getter(ListTrafficPolicyInstancesByHostedZoneRequest::trafficPolicyInstanceTypeMarkerAsString)).setter(ListTrafficPolicyInstancesByHostedZoneRequest.setter(Builder::trafficPolicyInstanceTypeMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("trafficpolicyinstancetype").unmarshallLocationName("trafficpolicyinstancetype").build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxItems").getter(ListTrafficPolicyInstancesByHostedZoneRequest.getter(ListTrafficPolicyInstancesByHostedZoneRequest::maxItems)).setter(ListTrafficPolicyInstancesByHostedZoneRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxitems").unmarshallLocationName("maxitems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD, TRAFFIC_POLICY_INSTANCE_NAME_MARKER_FIELD, TRAFFIC_POLICY_INSTANCE_TYPE_MARKER_FIELD, MAX_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTrafficPolicyInstancesByHostedZoneRequest.memberNameToFieldInitializer();
    private final String hostedZoneId;
    private final String trafficPolicyInstanceNameMarker;
    private final String trafficPolicyInstanceTypeMarker;
    private final String maxItems;

    private ListTrafficPolicyInstancesByHostedZoneRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.trafficPolicyInstanceNameMarker = builder.trafficPolicyInstanceNameMarker;
        this.trafficPolicyInstanceTypeMarker = builder.trafficPolicyInstanceTypeMarker;
        this.maxItems = builder.maxItems;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public final String trafficPolicyInstanceNameMarker() {
        return this.trafficPolicyInstanceNameMarker;
    }

    public final RRType trafficPolicyInstanceTypeMarker() {
        return RRType.fromValue(this.trafficPolicyInstanceTypeMarker);
    }

    public final String trafficPolicyInstanceTypeMarkerAsString() {
        return this.trafficPolicyInstanceTypeMarker;
    }

    public final String maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyInstanceNameMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyInstanceTypeMarkerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyInstancesByHostedZoneRequest)) {
            return false;
        }
        ListTrafficPolicyInstancesByHostedZoneRequest other = (ListTrafficPolicyInstancesByHostedZoneRequest)((Object)obj);
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.trafficPolicyInstanceNameMarker(), other.trafficPolicyInstanceNameMarker()) && Objects.equals(this.trafficPolicyInstanceTypeMarkerAsString(), other.trafficPolicyInstanceTypeMarkerAsString()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrafficPolicyInstancesByHostedZoneRequest").add("HostedZoneId", (Object)this.hostedZoneId()).add("TrafficPolicyInstanceNameMarker", (Object)this.trafficPolicyInstanceNameMarker()).add("TrafficPolicyInstanceTypeMarker", (Object)this.trafficPolicyInstanceTypeMarkerAsString()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "TrafficPolicyInstanceNameMarker": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyInstanceNameMarker()));
            }
            case "TrafficPolicyInstanceTypeMarker": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyInstanceTypeMarkerAsString()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("id", HOSTED_ZONE_ID_FIELD);
        map.put("trafficpolicyinstancename", TRAFFIC_POLICY_INSTANCE_NAME_MARKER_FIELD);
        map.put("trafficpolicyinstancetype", TRAFFIC_POLICY_INSTANCE_TYPE_MARKER_FIELD);
        map.put("maxitems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrafficPolicyInstancesByHostedZoneRequest, T> g) {
        return obj -> g.apply((ListTrafficPolicyInstancesByHostedZoneRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private String trafficPolicyInstanceNameMarker;
        private String trafficPolicyInstanceTypeMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyInstancesByHostedZoneRequest model) {
            super(model);
            this.hostedZoneId(model.hostedZoneId);
            this.trafficPolicyInstanceNameMarker(model.trafficPolicyInstanceNameMarker);
            this.trafficPolicyInstanceTypeMarker(model.trafficPolicyInstanceTypeMarker);
            this.maxItems(model.maxItems);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getTrafficPolicyInstanceNameMarker() {
            return this.trafficPolicyInstanceNameMarker;
        }

        public final void setTrafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
            return this;
        }

        public final String getTrafficPolicyInstanceTypeMarker() {
            return this.trafficPolicyInstanceTypeMarker;
        }

        public final void setTrafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
            return this;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker(trafficPolicyInstanceTypeMarker == null ? null : trafficPolicyInstanceTypeMarker.toString());
            return this;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrafficPolicyInstancesByHostedZoneRequest build() {
            return new ListTrafficPolicyInstancesByHostedZoneRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrafficPolicyInstancesByHostedZoneRequest> {
        public Builder hostedZoneId(String var1);

        public Builder trafficPolicyInstanceNameMarker(String var1);

        public Builder trafficPolicyInstanceTypeMarker(String var1);

        public Builder trafficPolicyInstanceTypeMarker(RRType var1);

        public Builder maxItems(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

