/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.ChangeInfo;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetChangeResponse
extends Route53Response
implements ToCopyableBuilder<Builder, GetChangeResponse> {
    private static final SdkField<ChangeInfo> CHANGE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChangeInfo").getter(GetChangeResponse.getter(GetChangeResponse::changeInfo)).setter(GetChangeResponse.setter(Builder::changeInfo)).constructor(ChangeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeInfo").unmarshallLocationName("ChangeInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetChangeResponse.memberNameToFieldInitializer();
    private final ChangeInfo changeInfo;

    private GetChangeResponse(BuilderImpl builder) {
        super(builder);
        this.changeInfo = builder.changeInfo;
    }

    public final ChangeInfo changeInfo() {
        return this.changeInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.changeInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChangeResponse)) {
            return false;
        }
        GetChangeResponse other = (GetChangeResponse)((Object)obj);
        return Objects.equals(this.changeInfo(), other.changeInfo());
    }

    public final String toString() {
        return ToString.builder((String)"GetChangeResponse").add("ChangeInfo", (Object)this.changeInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChangeInfo": {
                return Optional.ofNullable(clazz.cast(this.changeInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<ChangeInfo>> map = new HashMap<String, SdkField<ChangeInfo>>();
        map.put("ChangeInfo", CHANGE_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetChangeResponse, T> g) {
        return obj -> g.apply((GetChangeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private ChangeInfo changeInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChangeResponse model) {
            super(model);
            this.changeInfo(model.changeInfo);
        }

        public final ChangeInfo.Builder getChangeInfo() {
            return this.changeInfo != null ? this.changeInfo.toBuilder() : null;
        }

        public final void setChangeInfo(ChangeInfo.BuilderImpl changeInfo) {
            this.changeInfo = changeInfo != null ? changeInfo.build() : null;
        }

        @Override
        public final Builder changeInfo(ChangeInfo changeInfo) {
            this.changeInfo = changeInfo;
            return this;
        }

        @Override
        public GetChangeResponse build() {
            return new GetChangeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetChangeResponse> {
        public Builder changeInfo(ChangeInfo var1);

        default public Builder changeInfo(Consumer<ChangeInfo.Builder> changeInfo) {
            return this.changeInfo((ChangeInfo)((ChangeInfo.Builder)ChangeInfo.builder().applyMutation(changeInfo)).build());
        }
    }
}

