/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.services.route53.model.Tag;
import software.amazon.awssdk.services.route53.model.TagKeyListCopier;
import software.amazon.awssdk.services.route53.model.TagListCopier;
import software.amazon.awssdk.services.route53.model.TagResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeTagsForResourceRequest
extends Route53Request
implements ToCopyableBuilder<Builder, ChangeTagsForResourceRequest> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ChangeTagsForResourceRequest.getter(ChangeTagsForResourceRequest::resourceTypeAsString)).setter(ChangeTagsForResourceRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceType").unmarshallLocationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ChangeTagsForResourceRequest.getter(ChangeTagsForResourceRequest::resourceId)).setter(ChangeTagsForResourceRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceId").unmarshallLocationName("ResourceId").build()}).build();
    private static final SdkField<List<Tag>> ADD_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddTags").getter(ChangeTagsForResourceRequest.getter(ChangeTagsForResourceRequest::addTags)).setter(ChangeTagsForResourceRequest.setter(Builder::addTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddTags").unmarshallLocationName("AddTags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").unmarshallLocationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_TAG_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveTagKeys").getter(ChangeTagsForResourceRequest.getter(ChangeTagsForResourceRequest::removeTagKeys)).setter(ChangeTagsForResourceRequest.setter(Builder::removeTagKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveTagKeys").unmarshallLocationName("RemoveTagKeys").build(), ListTrait.builder().memberLocationName("Key").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").unmarshallLocationName("Key").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, ADD_TAGS_FIELD, REMOVE_TAG_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("ResourceId", RESOURCE_ID_FIELD);
            this.put("AddTags", ADD_TAGS_FIELD);
            this.put("RemoveTagKeys", REMOVE_TAG_KEYS_FIELD);
        }
    });
    private final String resourceType;
    private final String resourceId;
    private final List<Tag> addTags;
    private final List<String> removeTagKeys;

    private ChangeTagsForResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.addTags = builder.addTags;
        this.removeTagKeys = builder.removeTagKeys;
    }

    public final TagResourceType resourceType() {
        return TagResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final boolean hasAddTags() {
        return this.addTags != null && !(this.addTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> addTags() {
        return this.addTags;
    }

    public final boolean hasRemoveTagKeys() {
        return this.removeTagKeys != null && !(this.removeTagKeys instanceof SdkAutoConstructList);
    }

    public final List<String> removeTagKeys() {
        return this.removeTagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddTags() ? this.addTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveTagKeys() ? this.removeTagKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeTagsForResourceRequest)) {
            return false;
        }
        ChangeTagsForResourceRequest other = (ChangeTagsForResourceRequest)((Object)obj);
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && this.hasAddTags() == other.hasAddTags() && Objects.equals(this.addTags(), other.addTags()) && this.hasRemoveTagKeys() == other.hasRemoveTagKeys() && Objects.equals(this.removeTagKeys(), other.removeTagKeys());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeTagsForResourceRequest").add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceId", (Object)this.resourceId()).add("AddTags", this.hasAddTags() ? this.addTags() : null).add("RemoveTagKeys", this.hasRemoveTagKeys() ? this.removeTagKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "AddTags": {
                return Optional.ofNullable(clazz.cast(this.addTags()));
            }
            case "RemoveTagKeys": {
                return Optional.ofNullable(clazz.cast(this.removeTagKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ChangeTagsForResourceRequest, T> g) {
        return obj -> g.apply((ChangeTagsForResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String resourceType;
        private String resourceId;
        private List<Tag> addTags = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeTagKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeTagsForResourceRequest model) {
            super(model);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.addTags(model.addTags);
            this.removeTagKeys(model.removeTagKeys);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TagResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final List<Tag.Builder> getAddTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.addTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddTags(Collection<Tag.BuilderImpl> addTags) {
            this.addTags = TagListCopier.copyFromBuilder(addTags);
        }

        @Override
        public final Builder addTags(Collection<Tag> addTags) {
            this.addTags = TagListCopier.copy(addTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Tag ... addTags) {
            this.addTags(Arrays.asList(addTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Consumer<Tag.Builder> ... addTags) {
            this.addTags(Stream.of(addTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRemoveTagKeys() {
            if (this.removeTagKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeTagKeys;
        }

        public final void setRemoveTagKeys(Collection<String> removeTagKeys) {
            this.removeTagKeys = TagKeyListCopier.copy(removeTagKeys);
        }

        @Override
        public final Builder removeTagKeys(Collection<String> removeTagKeys) {
            this.removeTagKeys = TagKeyListCopier.copy(removeTagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTagKeys(String ... removeTagKeys) {
            this.removeTagKeys(Arrays.asList(removeTagKeys));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChangeTagsForResourceRequest build() {
            return new ChangeTagsForResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ChangeTagsForResourceRequest> {
        public Builder resourceType(String var1);

        public Builder resourceType(TagResourceType var1);

        public Builder resourceId(String var1);

        public Builder addTags(Collection<Tag> var1);

        public Builder addTags(Tag ... var1);

        public Builder addTags(Consumer<Tag.Builder> ... var1);

        public Builder removeTagKeys(Collection<String> var1);

        public Builder removeTagKeys(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

