/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKeySigningKeyRequest
extends Route53Request
implements ToCopyableBuilder<Builder, CreateKeySigningKeyRequest> {
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallerReference").getter(CreateKeySigningKeyRequest.getter(CreateKeySigningKeyRequest::callerReference)).setter(CreateKeySigningKeyRequest.setter(Builder::callerReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference").unmarshallLocationName("CallerReference").build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(CreateKeySigningKeyRequest.getter(CreateKeySigningKeyRequest::hostedZoneId)).setter(CreateKeySigningKeyRequest.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").unmarshallLocationName("HostedZoneId").build()}).build();
    private static final SdkField<String> KEY_MANAGEMENT_SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyManagementServiceArn").getter(CreateKeySigningKeyRequest.getter(CreateKeySigningKeyRequest::keyManagementServiceArn)).setter(CreateKeySigningKeyRequest.setter(Builder::keyManagementServiceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyManagementServiceArn").unmarshallLocationName("KeyManagementServiceArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateKeySigningKeyRequest.getter(CreateKeySigningKeyRequest::name)).setter(CreateKeySigningKeyRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateKeySigningKeyRequest.getter(CreateKeySigningKeyRequest::status)).setter(CreateKeySigningKeyRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLER_REFERENCE_FIELD, HOSTED_ZONE_ID_FIELD, KEY_MANAGEMENT_SERVICE_ARN_FIELD, NAME_FIELD, STATUS_FIELD));
    private final String callerReference;
    private final String hostedZoneId;
    private final String keyManagementServiceArn;
    private final String name;
    private final String status;

    private CreateKeySigningKeyRequest(BuilderImpl builder) {
        super(builder);
        this.callerReference = builder.callerReference;
        this.hostedZoneId = builder.hostedZoneId;
        this.keyManagementServiceArn = builder.keyManagementServiceArn;
        this.name = builder.name;
        this.status = builder.status;
    }

    public final String callerReference() {
        return this.callerReference;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public final String keyManagementServiceArn() {
        return this.keyManagementServiceArn;
    }

    public final String name() {
        return this.name;
    }

    public final String status() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyManagementServiceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeySigningKeyRequest)) {
            return false;
        }
        CreateKeySigningKeyRequest other = (CreateKeySigningKeyRequest)((Object)obj);
        return Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.keyManagementServiceArn(), other.keyManagementServiceArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKeySigningKeyRequest").add("CallerReference", (Object)this.callerReference()).add("HostedZoneId", (Object)this.hostedZoneId()).add("KeyManagementServiceArn", (Object)this.keyManagementServiceArn()).add("Name", (Object)this.name()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallerReference": {
                return Optional.ofNullable(clazz.cast(this.callerReference()));
            }
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "KeyManagementServiceArn": {
                return Optional.ofNullable(clazz.cast(this.keyManagementServiceArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKeySigningKeyRequest, T> g) {
        return obj -> g.apply((CreateKeySigningKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String callerReference;
        private String hostedZoneId;
        private String keyManagementServiceArn;
        private String name;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeySigningKeyRequest model) {
            super(model);
            this.callerReference(model.callerReference);
            this.hostedZoneId(model.hostedZoneId);
            this.keyManagementServiceArn(model.keyManagementServiceArn);
            this.name(model.name);
            this.status(model.status);
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getKeyManagementServiceArn() {
            return this.keyManagementServiceArn;
        }

        @Override
        public final Builder keyManagementServiceArn(String keyManagementServiceArn) {
            this.keyManagementServiceArn = keyManagementServiceArn;
            return this;
        }

        public final void setKeyManagementServiceArn(String keyManagementServiceArn) {
            this.keyManagementServiceArn = keyManagementServiceArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKeySigningKeyRequest build() {
            return new CreateKeySigningKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKeySigningKeyRequest> {
        public Builder callerReference(String var1);

        public Builder hostedZoneId(String var1);

        public Builder keyManagementServiceArn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

