/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.HostedZoneSummariesCopier;
import software.amazon.awssdk.services.route53.model.HostedZoneSummary;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHostedZonesByVpcResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListHostedZonesByVpcResponse> {
    private static final SdkField<List<HostedZoneSummary>> HOSTED_ZONE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HostedZoneSummaries").getter(ListHostedZonesByVpcResponse.getter(ListHostedZonesByVpcResponse::hostedZoneSummaries)).setter(ListHostedZonesByVpcResponse.setter(Builder::hostedZoneSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneSummaries").unmarshallLocationName("HostedZoneSummaries").build(), ListTrait.builder().memberLocationName("HostedZoneSummary").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HostedZoneSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneSummary").unmarshallLocationName("HostedZoneSummary").build()}).build()).build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxItems").getter(ListHostedZonesByVpcResponse.getter(ListHostedZonesByVpcResponse::maxItems)).setter(ListHostedZonesByVpcResponse.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListHostedZonesByVpcResponse.getter(ListHostedZonesByVpcResponse::nextToken)).setter(ListHostedZonesByVpcResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_SUMMARIES_FIELD, MAX_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<HostedZoneSummary> hostedZoneSummaries;
    private final String maxItems;
    private final String nextToken;

    private ListHostedZonesByVpcResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZoneSummaries = builder.hostedZoneSummaries;
        this.maxItems = builder.maxItems;
        this.nextToken = builder.nextToken;
    }

    public boolean hasHostedZoneSummaries() {
        return this.hostedZoneSummaries != null && !(this.hostedZoneSummaries instanceof SdkAutoConstructList);
    }

    public List<HostedZoneSummary> hostedZoneSummaries() {
        return this.hostedZoneSummaries;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesByVpcResponse)) {
            return false;
        }
        ListHostedZonesByVpcResponse other = (ListHostedZonesByVpcResponse)((Object)obj);
        return Objects.equals(this.hostedZoneSummaries(), other.hostedZoneSummaries()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListHostedZonesByVpcResponse").add("HostedZoneSummaries", this.hostedZoneSummaries()).add("MaxItems", (Object)this.maxItems()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneSummaries": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneSummaries()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHostedZonesByVpcResponse, T> g) {
        return obj -> g.apply((ListHostedZonesByVpcResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<HostedZoneSummary> hostedZoneSummaries = DefaultSdkAutoConstructList.getInstance();
        private String maxItems;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesByVpcResponse model) {
            super(model);
            this.hostedZoneSummaries(model.hostedZoneSummaries);
            this.maxItems(model.maxItems);
            this.nextToken(model.nextToken);
        }

        public final Collection<HostedZoneSummary.Builder> getHostedZoneSummaries() {
            return this.hostedZoneSummaries != null ? (Collection)this.hostedZoneSummaries.stream().map(HostedZoneSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hostedZoneSummaries(Collection<HostedZoneSummary> hostedZoneSummaries) {
            this.hostedZoneSummaries = HostedZoneSummariesCopier.copy(hostedZoneSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZoneSummaries(HostedZoneSummary ... hostedZoneSummaries) {
            this.hostedZoneSummaries(Arrays.asList(hostedZoneSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZoneSummaries(Consumer<HostedZoneSummary.Builder> ... hostedZoneSummaries) {
            this.hostedZoneSummaries(Stream.of(hostedZoneSummaries).map(c -> (HostedZoneSummary)((HostedZoneSummary.Builder)HostedZoneSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHostedZoneSummaries(Collection<HostedZoneSummary.BuilderImpl> hostedZoneSummaries) {
            this.hostedZoneSummaries = HostedZoneSummariesCopier.copyFromBuilder(hostedZoneSummaries);
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListHostedZonesByVpcResponse build() {
            return new ListHostedZonesByVpcResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHostedZonesByVpcResponse> {
        public Builder hostedZoneSummaries(Collection<HostedZoneSummary> var1);

        public Builder hostedZoneSummaries(HostedZoneSummary ... var1);

        public Builder hostedZoneSummaries(Consumer<HostedZoneSummary.Builder> ... var1);

        public Builder maxItems(String var1);

        public Builder nextToken(String var1);
    }
}

