/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.CheckerIpRangesCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCheckerIpRangesResponse
extends Route53Response
implements ToCopyableBuilder<Builder, GetCheckerIpRangesResponse> {
    private static final SdkField<List<String>> CHECKER_IP_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CheckerIpRanges").getter(GetCheckerIpRangesResponse.getter(GetCheckerIpRangesResponse::checkerIpRanges)).setter(GetCheckerIpRangesResponse.setter(Builder::checkerIpRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckerIpRanges").unmarshallLocationName("CheckerIpRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKER_IP_RANGES_FIELD));
    private final List<String> checkerIpRanges;

    private GetCheckerIpRangesResponse(BuilderImpl builder) {
        super(builder);
        this.checkerIpRanges = builder.checkerIpRanges;
    }

    public boolean hasCheckerIpRanges() {
        return this.checkerIpRanges != null && !(this.checkerIpRanges instanceof SdkAutoConstructList);
    }

    public List<String> checkerIpRanges() {
        return this.checkerIpRanges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.checkerIpRanges());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCheckerIpRangesResponse)) {
            return false;
        }
        GetCheckerIpRangesResponse other = (GetCheckerIpRangesResponse)((Object)obj);
        return Objects.equals(this.checkerIpRanges(), other.checkerIpRanges());
    }

    public String toString() {
        return ToString.builder((String)"GetCheckerIpRangesResponse").add("CheckerIpRanges", this.checkerIpRanges()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CheckerIpRanges": {
                return Optional.ofNullable(clazz.cast(this.checkerIpRanges()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCheckerIpRangesResponse, T> g) {
        return obj -> g.apply((GetCheckerIpRangesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<String> checkerIpRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCheckerIpRangesResponse model) {
            super(model);
            this.checkerIpRanges(model.checkerIpRanges);
        }

        public final Collection<String> getCheckerIpRanges() {
            return this.checkerIpRanges;
        }

        @Override
        public final Builder checkerIpRanges(Collection<String> checkerIpRanges) {
            this.checkerIpRanges = CheckerIpRangesCopier.copy(checkerIpRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkerIpRanges(String ... checkerIpRanges) {
            this.checkerIpRanges(Arrays.asList(checkerIpRanges));
            return this;
        }

        public final void setCheckerIpRanges(Collection<String> checkerIpRanges) {
            this.checkerIpRanges = CheckerIpRangesCopier.copy(checkerIpRanges);
        }

        @Override
        public GetCheckerIpRangesResponse build() {
            return new GetCheckerIpRangesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCheckerIpRangesResponse> {
        public Builder checkerIpRanges(Collection<String> var1);

        public Builder checkerIpRanges(String ... var1);
    }
}

