/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.route53.Route53AsyncClient;
import software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceResponse;
import software.amazon.awssdk.services.route53.model.ConcurrentModificationException;
import software.amazon.awssdk.services.route53.model.ConflictingDomainExistsException;
import software.amazon.awssdk.services.route53.model.ConflictingTypesException;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionResponse;
import software.amazon.awssdk.services.route53.model.CreateVpcAssociationAuthorizationRequest;
import software.amazon.awssdk.services.route53.model.CreateVpcAssociationAuthorizationResponse;
import software.amazon.awssdk.services.route53.model.DelegationSetAlreadyCreatedException;
import software.amazon.awssdk.services.route53.model.DelegationSetAlreadyReusableException;
import software.amazon.awssdk.services.route53.model.DelegationSetInUseException;
import software.amazon.awssdk.services.route53.model.DelegationSetNotAvailableException;
import software.amazon.awssdk.services.route53.model.DelegationSetNotReusableException;
import software.amazon.awssdk.services.route53.model.DeleteHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.DeleteHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationRequest;
import software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationResponse;
import software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetAccountLimitRequest;
import software.amazon.awssdk.services.route53.model.GetAccountLimitResponse;
import software.amazon.awssdk.services.route53.model.GetChangeRequest;
import software.amazon.awssdk.services.route53.model.GetChangeResponse;
import software.amazon.awssdk.services.route53.model.GetCheckerIpRangesRequest;
import software.amazon.awssdk.services.route53.model.GetCheckerIpRangesResponse;
import software.amazon.awssdk.services.route53.model.GetGeoLocationRequest;
import software.amazon.awssdk.services.route53.model.GetGeoLocationResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckCountRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckCountResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckStatusRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckStatusResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneCountRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneCountResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneLimitRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneLimitResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitRequest;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitResponse;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.HealthCheckAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.HealthCheckVersionMismatchException;
import software.amazon.awssdk.services.route53.model.HostedZoneAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.HostedZoneNotEmptyException;
import software.amazon.awssdk.services.route53.model.HostedZoneNotFoundException;
import software.amazon.awssdk.services.route53.model.HostedZoneNotPrivateException;
import software.amazon.awssdk.services.route53.model.IncompatibleVersionException;
import software.amazon.awssdk.services.route53.model.InsufficientCloudWatchLogsResourcePolicyException;
import software.amazon.awssdk.services.route53.model.InvalidArgumentException;
import software.amazon.awssdk.services.route53.model.InvalidChangeBatchException;
import software.amazon.awssdk.services.route53.model.InvalidDomainNameException;
import software.amazon.awssdk.services.route53.model.InvalidInputException;
import software.amazon.awssdk.services.route53.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.route53.model.InvalidTrafficPolicyDocumentException;
import software.amazon.awssdk.services.route53.model.InvalidVpcIdException;
import software.amazon.awssdk.services.route53.model.LastVpcAssociationException;
import software.amazon.awssdk.services.route53.model.LimitsExceededException;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsResponse;
import software.amazon.awssdk.services.route53.model.ListHealthChecksRequest;
import software.amazon.awssdk.services.route53.model.ListHealthChecksResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesResponse;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsRequest;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsResponse;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53.model.ListTagsForResourcesRequest;
import software.amazon.awssdk.services.route53.model.ListTagsForResourcesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsResponse;
import software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsRequest;
import software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsResponse;
import software.amazon.awssdk.services.route53.model.NoSuchChangeException;
import software.amazon.awssdk.services.route53.model.NoSuchCloudWatchLogsLogGroupException;
import software.amazon.awssdk.services.route53.model.NoSuchDelegationSetException;
import software.amazon.awssdk.services.route53.model.NoSuchGeoLocationException;
import software.amazon.awssdk.services.route53.model.NoSuchHealthCheckException;
import software.amazon.awssdk.services.route53.model.NoSuchHostedZoneException;
import software.amazon.awssdk.services.route53.model.NoSuchQueryLoggingConfigException;
import software.amazon.awssdk.services.route53.model.NoSuchTrafficPolicyException;
import software.amazon.awssdk.services.route53.model.NoSuchTrafficPolicyInstanceException;
import software.amazon.awssdk.services.route53.model.NotAuthorizedException;
import software.amazon.awssdk.services.route53.model.PriorRequestNotCompleteException;
import software.amazon.awssdk.services.route53.model.PublicZoneVpcAssociationException;
import software.amazon.awssdk.services.route53.model.QueryLoggingConfigAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.Route53Exception;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.services.route53.model.TestDnsAnswerRequest;
import software.amazon.awssdk.services.route53.model.TestDnsAnswerResponse;
import software.amazon.awssdk.services.route53.model.ThrottlingException;
import software.amazon.awssdk.services.route53.model.TooManyHealthChecksException;
import software.amazon.awssdk.services.route53.model.TooManyHostedZonesException;
import software.amazon.awssdk.services.route53.model.TooManyTrafficPoliciesException;
import software.amazon.awssdk.services.route53.model.TooManyTrafficPolicyInstancesException;
import software.amazon.awssdk.services.route53.model.TooManyTrafficPolicyVersionsForCurrentPolicyException;
import software.amazon.awssdk.services.route53.model.TooManyVpcAssociationAuthorizationsException;
import software.amazon.awssdk.services.route53.model.TrafficPolicyAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.TrafficPolicyInUseException;
import software.amazon.awssdk.services.route53.model.TrafficPolicyInstanceAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.UpdateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentRequest;
import software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentResponse;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentRequest;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentResponse;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.VpcAssociationAuthorizationNotFoundException;
import software.amazon.awssdk.services.route53.model.VpcAssociationNotFoundException;
import software.amazon.awssdk.services.route53.paginators.ListHealthChecksPublisher;
import software.amazon.awssdk.services.route53.paginators.ListHostedZonesPublisher;
import software.amazon.awssdk.services.route53.paginators.ListQueryLoggingConfigsPublisher;
import software.amazon.awssdk.services.route53.paginators.ListResourceRecordSetsPublisher;
import software.amazon.awssdk.services.route53.transform.AssociateVpcWithHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ChangeResourceRecordSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ChangeTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateQueryLoggingConfigRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateVpcAssociationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteQueryLoggingConfigRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteVpcAssociationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DisassociateVpcFromHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetAccountLimitRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetChangeRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetCheckerIpRangesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetGeoLocationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckLastFailureReasonRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckStatusRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneLimitRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetQueryLoggingConfigRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetReusableDelegationSetLimitRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyInstanceCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListGeoLocationsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHealthChecksRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesByNameRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesByVpcRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListQueryLoggingConfigsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListResourceRecordSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListReusableDelegationSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTagsForResourcesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPoliciesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesByHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesByPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyVersionsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListVpcAssociationAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.TestDnsAnswerRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateHostedZoneCommentRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateTrafficPolicyCommentRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultRoute53AsyncClient
implements Route53AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultRoute53AsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsXmlProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRoute53AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "route53";
    }

    @Override
    public CompletableFuture<AssociateVpcWithHostedZoneResponse> associateVPCWithHostedZone(AssociateVpcWithHostedZoneRequest associateVpcWithHostedZoneRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, associateVpcWithHostedZoneRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateVPCWithHostedZone");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(AssociateVpcWithHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateVPCWithHostedZone").withMarshaller((Marshaller)new AssociateVpcWithHostedZoneRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)associateVpcWithHostedZoneRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateVpcWithHostedZoneRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$associateVPCWithHostedZone$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$associateVPCWithHostedZone$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ChangeResourceRecordSetsResponse> changeResourceRecordSets(ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, changeResourceRecordSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ChangeResourceRecordSets");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ChangeResourceRecordSetsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ChangeResourceRecordSets").withMarshaller((Marshaller)new ChangeResourceRecordSetsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)changeResourceRecordSetsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = changeResourceRecordSetsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$changeResourceRecordSets$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$changeResourceRecordSets$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ChangeTagsForResourceResponse> changeTagsForResource(ChangeTagsForResourceRequest changeTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, changeTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ChangeTagsForResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ChangeTagsForResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ChangeTagsForResource").withMarshaller((Marshaller)new ChangeTagsForResourceRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)changeTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = changeTagsForResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$changeTagsForResource$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$changeTagsForResource$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateHealthCheckResponse> createHealthCheck(CreateHealthCheckRequest createHealthCheckRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, createHealthCheckRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHealthCheck");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHealthCheck").withMarshaller((Marshaller)new CreateHealthCheckRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createHealthCheckRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createHealthCheckRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$createHealthCheck$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$createHealthCheck$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateHostedZoneResponse> createHostedZone(CreateHostedZoneRequest createHostedZoneRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, createHostedZoneRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHostedZone");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHostedZone").withMarshaller((Marshaller)new CreateHostedZoneRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createHostedZoneRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createHostedZoneRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$createHostedZone$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$createHostedZone$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateQueryLoggingConfigResponse> createQueryLoggingConfig(CreateQueryLoggingConfigRequest createQueryLoggingConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, createQueryLoggingConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateQueryLoggingConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateQueryLoggingConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateQueryLoggingConfig").withMarshaller((Marshaller)new CreateQueryLoggingConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createQueryLoggingConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createQueryLoggingConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$createQueryLoggingConfig$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$createQueryLoggingConfig$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateReusableDelegationSetResponse> createReusableDelegationSet(CreateReusableDelegationSetRequest createReusableDelegationSetRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, createReusableDelegationSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReusableDelegationSet");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateReusableDelegationSetResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReusableDelegationSet").withMarshaller((Marshaller)new CreateReusableDelegationSetRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createReusableDelegationSetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createReusableDelegationSetRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$createReusableDelegationSet$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$createReusableDelegationSet$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTrafficPolicyResponse> createTrafficPolicy(CreateTrafficPolicyRequest createTrafficPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, createTrafficPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrafficPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateTrafficPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrafficPolicy").withMarshaller((Marshaller)new CreateTrafficPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createTrafficPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createTrafficPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$createTrafficPolicy$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$createTrafficPolicy$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTrafficPolicyInstanceResponse> createTrafficPolicyInstance(CreateTrafficPolicyInstanceRequest createTrafficPolicyInstanceRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, createTrafficPolicyInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrafficPolicyInstance");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateTrafficPolicyInstanceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrafficPolicyInstance").withMarshaller((Marshaller)new CreateTrafficPolicyInstanceRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createTrafficPolicyInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createTrafficPolicyInstanceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$createTrafficPolicyInstance$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$createTrafficPolicyInstance$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTrafficPolicyVersionResponse> createTrafficPolicyVersion(CreateTrafficPolicyVersionRequest createTrafficPolicyVersionRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, createTrafficPolicyVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrafficPolicyVersion");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateTrafficPolicyVersionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrafficPolicyVersion").withMarshaller((Marshaller)new CreateTrafficPolicyVersionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createTrafficPolicyVersionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createTrafficPolicyVersionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$createTrafficPolicyVersion$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$createTrafficPolicyVersion$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateVpcAssociationAuthorizationResponse> createVPCAssociationAuthorization(CreateVpcAssociationAuthorizationRequest createVpcAssociationAuthorizationRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, createVpcAssociationAuthorizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVPCAssociationAuthorization");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateVpcAssociationAuthorizationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVPCAssociationAuthorization").withMarshaller((Marshaller)new CreateVpcAssociationAuthorizationRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createVpcAssociationAuthorizationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createVpcAssociationAuthorizationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$createVPCAssociationAuthorization$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$createVPCAssociationAuthorization$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteHealthCheckResponse> deleteHealthCheck(DeleteHealthCheckRequest deleteHealthCheckRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteHealthCheckRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteHealthCheck");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHealthCheck").withMarshaller((Marshaller)new DeleteHealthCheckRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteHealthCheckRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteHealthCheckRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$deleteHealthCheck$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$deleteHealthCheck$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteHostedZoneResponse> deleteHostedZone(DeleteHostedZoneRequest deleteHostedZoneRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteHostedZoneRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteHostedZone");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHostedZone").withMarshaller((Marshaller)new DeleteHostedZoneRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteHostedZoneRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteHostedZoneRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$deleteHostedZone$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$deleteHostedZone$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteQueryLoggingConfigResponse> deleteQueryLoggingConfig(DeleteQueryLoggingConfigRequest deleteQueryLoggingConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteQueryLoggingConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteQueryLoggingConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteQueryLoggingConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteQueryLoggingConfig").withMarshaller((Marshaller)new DeleteQueryLoggingConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteQueryLoggingConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteQueryLoggingConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$deleteQueryLoggingConfig$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$deleteQueryLoggingConfig$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteReusableDelegationSetResponse> deleteReusableDelegationSet(DeleteReusableDelegationSetRequest deleteReusableDelegationSetRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteReusableDelegationSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReusableDelegationSet");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteReusableDelegationSetResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReusableDelegationSet").withMarshaller((Marshaller)new DeleteReusableDelegationSetRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteReusableDelegationSetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteReusableDelegationSetRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$deleteReusableDelegationSet$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$deleteReusableDelegationSet$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTrafficPolicyResponse> deleteTrafficPolicy(DeleteTrafficPolicyRequest deleteTrafficPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteTrafficPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTrafficPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteTrafficPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrafficPolicy").withMarshaller((Marshaller)new DeleteTrafficPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteTrafficPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteTrafficPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$deleteTrafficPolicy$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$deleteTrafficPolicy$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTrafficPolicyInstanceResponse> deleteTrafficPolicyInstance(DeleteTrafficPolicyInstanceRequest deleteTrafficPolicyInstanceRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteTrafficPolicyInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTrafficPolicyInstance");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteTrafficPolicyInstanceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrafficPolicyInstance").withMarshaller((Marshaller)new DeleteTrafficPolicyInstanceRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteTrafficPolicyInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteTrafficPolicyInstanceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$deleteTrafficPolicyInstance$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$deleteTrafficPolicyInstance$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteVpcAssociationAuthorizationResponse> deleteVPCAssociationAuthorization(DeleteVpcAssociationAuthorizationRequest deleteVpcAssociationAuthorizationRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteVpcAssociationAuthorizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVPCAssociationAuthorization");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteVpcAssociationAuthorizationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVPCAssociationAuthorization").withMarshaller((Marshaller)new DeleteVpcAssociationAuthorizationRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteVpcAssociationAuthorizationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteVpcAssociationAuthorizationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$deleteVPCAssociationAuthorization$52(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$deleteVPCAssociationAuthorization$53((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateVpcFromHostedZoneResponse> disassociateVPCFromHostedZone(DisassociateVpcFromHostedZoneRequest disassociateVpcFromHostedZoneRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, disassociateVpcFromHostedZoneRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateVPCFromHostedZone");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DisassociateVpcFromHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateVPCFromHostedZone").withMarshaller((Marshaller)new DisassociateVpcFromHostedZoneRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)disassociateVpcFromHostedZoneRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociateVpcFromHostedZoneRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$disassociateVPCFromHostedZone$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$disassociateVPCFromHostedZone$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccountLimitResponse> getAccountLimit(GetAccountLimitRequest getAccountLimitRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getAccountLimitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccountLimit");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccountLimitResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccountLimit").withMarshaller((Marshaller)new GetAccountLimitRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getAccountLimitRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAccountLimitRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getAccountLimit$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getAccountLimit$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetChangeResponse> getChange(GetChangeRequest getChangeRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getChangeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetChange");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetChangeResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetChange").withMarshaller((Marshaller)new GetChangeRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getChangeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getChangeRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getChange$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getChange$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCheckerIpRangesResponse> getCheckerIpRanges(GetCheckerIpRangesRequest getCheckerIpRangesRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getCheckerIpRangesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCheckerIpRanges");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetCheckerIpRangesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCheckerIpRanges").withMarshaller((Marshaller)new GetCheckerIpRangesRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getCheckerIpRangesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCheckerIpRangesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getCheckerIpRanges$64(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getCheckerIpRanges$65((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetGeoLocationResponse> getGeoLocation(GetGeoLocationRequest getGeoLocationRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getGeoLocationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGeoLocation");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetGeoLocationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGeoLocation").withMarshaller((Marshaller)new GetGeoLocationRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getGeoLocationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getGeoLocationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getGeoLocation$67(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getGeoLocation$68((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetHealthCheckResponse> getHealthCheck(GetHealthCheckRequest getHealthCheckRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getHealthCheckRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHealthCheck");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHealthCheck").withMarshaller((Marshaller)new GetHealthCheckRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getHealthCheckRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getHealthCheckRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getHealthCheck$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getHealthCheck$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetHealthCheckCountResponse> getHealthCheckCount(GetHealthCheckCountRequest getHealthCheckCountRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getHealthCheckCountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHealthCheckCount");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetHealthCheckCountResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHealthCheckCount").withMarshaller((Marshaller)new GetHealthCheckCountRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getHealthCheckCountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getHealthCheckCountRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getHealthCheckCount$73(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getHealthCheckCount$74((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetHealthCheckLastFailureReasonResponse> getHealthCheckLastFailureReason(GetHealthCheckLastFailureReasonRequest getHealthCheckLastFailureReasonRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getHealthCheckLastFailureReasonRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHealthCheckLastFailureReason");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetHealthCheckLastFailureReasonResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHealthCheckLastFailureReason").withMarshaller((Marshaller)new GetHealthCheckLastFailureReasonRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getHealthCheckLastFailureReasonRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getHealthCheckLastFailureReasonRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getHealthCheckLastFailureReason$76(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getHealthCheckLastFailureReason$77((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetHealthCheckStatusResponse> getHealthCheckStatus(GetHealthCheckStatusRequest getHealthCheckStatusRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getHealthCheckStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHealthCheckStatus");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetHealthCheckStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHealthCheckStatus").withMarshaller((Marshaller)new GetHealthCheckStatusRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getHealthCheckStatusRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getHealthCheckStatusRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getHealthCheckStatus$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getHealthCheckStatus$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetHostedZoneResponse> getHostedZone(GetHostedZoneRequest getHostedZoneRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getHostedZoneRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHostedZone");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHostedZone").withMarshaller((Marshaller)new GetHostedZoneRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getHostedZoneRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getHostedZoneRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getHostedZone$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getHostedZone$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetHostedZoneCountResponse> getHostedZoneCount(GetHostedZoneCountRequest getHostedZoneCountRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getHostedZoneCountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHostedZoneCount");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetHostedZoneCountResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHostedZoneCount").withMarshaller((Marshaller)new GetHostedZoneCountRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getHostedZoneCountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getHostedZoneCountRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getHostedZoneCount$85(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getHostedZoneCount$86((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetHostedZoneLimitResponse> getHostedZoneLimit(GetHostedZoneLimitRequest getHostedZoneLimitRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getHostedZoneLimitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHostedZoneLimit");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetHostedZoneLimitResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHostedZoneLimit").withMarshaller((Marshaller)new GetHostedZoneLimitRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getHostedZoneLimitRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getHostedZoneLimitRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getHostedZoneLimit$88(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getHostedZoneLimit$89((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetQueryLoggingConfigResponse> getQueryLoggingConfig(GetQueryLoggingConfigRequest getQueryLoggingConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getQueryLoggingConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryLoggingConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetQueryLoggingConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryLoggingConfig").withMarshaller((Marshaller)new GetQueryLoggingConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getQueryLoggingConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getQueryLoggingConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getQueryLoggingConfig$91(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getQueryLoggingConfig$92((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReusableDelegationSetResponse> getReusableDelegationSet(GetReusableDelegationSetRequest getReusableDelegationSetRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getReusableDelegationSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReusableDelegationSet");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetReusableDelegationSetResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReusableDelegationSet").withMarshaller((Marshaller)new GetReusableDelegationSetRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getReusableDelegationSetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getReusableDelegationSetRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getReusableDelegationSet$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getReusableDelegationSet$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReusableDelegationSetLimitResponse> getReusableDelegationSetLimit(GetReusableDelegationSetLimitRequest getReusableDelegationSetLimitRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getReusableDelegationSetLimitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReusableDelegationSetLimit");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetReusableDelegationSetLimitResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReusableDelegationSetLimit").withMarshaller((Marshaller)new GetReusableDelegationSetLimitRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getReusableDelegationSetLimitRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getReusableDelegationSetLimitRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getReusableDelegationSetLimit$97(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getReusableDelegationSetLimit$98((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTrafficPolicyResponse> getTrafficPolicy(GetTrafficPolicyRequest getTrafficPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getTrafficPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTrafficPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetTrafficPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrafficPolicy").withMarshaller((Marshaller)new GetTrafficPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getTrafficPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getTrafficPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getTrafficPolicy$100(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getTrafficPolicy$101((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTrafficPolicyInstanceResponse> getTrafficPolicyInstance(GetTrafficPolicyInstanceRequest getTrafficPolicyInstanceRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getTrafficPolicyInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTrafficPolicyInstance");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetTrafficPolicyInstanceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrafficPolicyInstance").withMarshaller((Marshaller)new GetTrafficPolicyInstanceRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getTrafficPolicyInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getTrafficPolicyInstanceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getTrafficPolicyInstance$103(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getTrafficPolicyInstance$104((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTrafficPolicyInstanceCountResponse> getTrafficPolicyInstanceCount(GetTrafficPolicyInstanceCountRequest getTrafficPolicyInstanceCountRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, getTrafficPolicyInstanceCountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTrafficPolicyInstanceCount");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetTrafficPolicyInstanceCountResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrafficPolicyInstanceCount").withMarshaller((Marshaller)new GetTrafficPolicyInstanceCountRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getTrafficPolicyInstanceCountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getTrafficPolicyInstanceCountRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$getTrafficPolicyInstanceCount$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$getTrafficPolicyInstanceCount$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListGeoLocationsResponse> listGeoLocations(ListGeoLocationsRequest listGeoLocationsRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listGeoLocationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGeoLocations");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListGeoLocationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGeoLocations").withMarshaller((Marshaller)new ListGeoLocationsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listGeoLocationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listGeoLocationsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listGeoLocations$109(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listGeoLocations$110((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListHealthChecksResponse> listHealthChecks(ListHealthChecksRequest listHealthChecksRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listHealthChecksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHealthChecks");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListHealthChecksResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHealthChecks").withMarshaller((Marshaller)new ListHealthChecksRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listHealthChecksRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listHealthChecksRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listHealthChecks$112(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listHealthChecks$113((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListHealthChecksPublisher listHealthChecksPaginator(ListHealthChecksRequest listHealthChecksRequest) {
        return new ListHealthChecksPublisher(this, this.applyPaginatorUserAgent(listHealthChecksRequest));
    }

    @Override
    public CompletableFuture<ListHostedZonesResponse> listHostedZones(ListHostedZonesRequest listHostedZonesRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listHostedZonesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHostedZones");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListHostedZonesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHostedZones").withMarshaller((Marshaller)new ListHostedZonesRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listHostedZonesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listHostedZonesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listHostedZones$115(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listHostedZones$116((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListHostedZonesByNameResponse> listHostedZonesByName(ListHostedZonesByNameRequest listHostedZonesByNameRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listHostedZonesByNameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHostedZonesByName");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListHostedZonesByNameResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHostedZonesByName").withMarshaller((Marshaller)new ListHostedZonesByNameRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listHostedZonesByNameRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listHostedZonesByNameRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listHostedZonesByName$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listHostedZonesByName$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListHostedZonesByVpcResponse> listHostedZonesByVPC(ListHostedZonesByVpcRequest listHostedZonesByVpcRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listHostedZonesByVpcRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHostedZonesByVPC");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListHostedZonesByVpcResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHostedZonesByVPC").withMarshaller((Marshaller)new ListHostedZonesByVpcRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listHostedZonesByVpcRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listHostedZonesByVpcRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listHostedZonesByVPC$121(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listHostedZonesByVPC$122((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListHostedZonesPublisher listHostedZonesPaginator(ListHostedZonesRequest listHostedZonesRequest) {
        return new ListHostedZonesPublisher(this, this.applyPaginatorUserAgent(listHostedZonesRequest));
    }

    @Override
    public CompletableFuture<ListQueryLoggingConfigsResponse> listQueryLoggingConfigs(ListQueryLoggingConfigsRequest listQueryLoggingConfigsRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listQueryLoggingConfigsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListQueryLoggingConfigs");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListQueryLoggingConfigsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQueryLoggingConfigs").withMarshaller((Marshaller)new ListQueryLoggingConfigsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listQueryLoggingConfigsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listQueryLoggingConfigsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listQueryLoggingConfigs$124(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listQueryLoggingConfigs$125((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListQueryLoggingConfigsPublisher listQueryLoggingConfigsPaginator(ListQueryLoggingConfigsRequest listQueryLoggingConfigsRequest) {
        return new ListQueryLoggingConfigsPublisher(this, this.applyPaginatorUserAgent(listQueryLoggingConfigsRequest));
    }

    @Override
    public CompletableFuture<ListResourceRecordSetsResponse> listResourceRecordSets(ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listResourceRecordSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceRecordSets");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListResourceRecordSetsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceRecordSets").withMarshaller((Marshaller)new ListResourceRecordSetsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listResourceRecordSetsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listResourceRecordSetsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listResourceRecordSets$127(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listResourceRecordSets$128((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListResourceRecordSetsPublisher listResourceRecordSetsPaginator(ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        return new ListResourceRecordSetsPublisher(this, this.applyPaginatorUserAgent(listResourceRecordSetsRequest));
    }

    @Override
    public CompletableFuture<ListReusableDelegationSetsResponse> listReusableDelegationSets(ListReusableDelegationSetsRequest listReusableDelegationSetsRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listReusableDelegationSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReusableDelegationSets");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListReusableDelegationSetsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReusableDelegationSets").withMarshaller((Marshaller)new ListReusableDelegationSetsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listReusableDelegationSetsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listReusableDelegationSetsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listReusableDelegationSets$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listReusableDelegationSets$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTagsForResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listTagsForResource$133(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listTagsForResource$134((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourcesResponse> listTagsForResources(ListTagsForResourcesRequest listTagsForResourcesRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResources");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTagsForResourcesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResources").withMarshaller((Marshaller)new ListTagsForResourcesRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listTagsForResourcesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourcesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listTagsForResources$136(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listTagsForResources$137((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTrafficPoliciesResponse> listTrafficPolicies(ListTrafficPoliciesRequest listTrafficPoliciesRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listTrafficPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTrafficPolicies");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTrafficPoliciesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrafficPolicies").withMarshaller((Marshaller)new ListTrafficPoliciesRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listTrafficPoliciesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTrafficPoliciesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listTrafficPolicies$139(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listTrafficPolicies$140((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTrafficPolicyInstancesResponse> listTrafficPolicyInstances(ListTrafficPolicyInstancesRequest listTrafficPolicyInstancesRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listTrafficPolicyInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTrafficPolicyInstances");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTrafficPolicyInstancesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrafficPolicyInstances").withMarshaller((Marshaller)new ListTrafficPolicyInstancesRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listTrafficPolicyInstancesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTrafficPolicyInstancesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listTrafficPolicyInstances$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listTrafficPolicyInstances$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTrafficPolicyInstancesByHostedZoneResponse> listTrafficPolicyInstancesByHostedZone(ListTrafficPolicyInstancesByHostedZoneRequest listTrafficPolicyInstancesByHostedZoneRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listTrafficPolicyInstancesByHostedZoneRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTrafficPolicyInstancesByHostedZone");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTrafficPolicyInstancesByHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrafficPolicyInstancesByHostedZone").withMarshaller((Marshaller)new ListTrafficPolicyInstancesByHostedZoneRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listTrafficPolicyInstancesByHostedZoneRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTrafficPolicyInstancesByHostedZoneRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listTrafficPolicyInstancesByHostedZone$145(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listTrafficPolicyInstancesByHostedZone$146((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTrafficPolicyInstancesByPolicyResponse> listTrafficPolicyInstancesByPolicy(ListTrafficPolicyInstancesByPolicyRequest listTrafficPolicyInstancesByPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listTrafficPolicyInstancesByPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTrafficPolicyInstancesByPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTrafficPolicyInstancesByPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrafficPolicyInstancesByPolicy").withMarshaller((Marshaller)new ListTrafficPolicyInstancesByPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listTrafficPolicyInstancesByPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTrafficPolicyInstancesByPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listTrafficPolicyInstancesByPolicy$148(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listTrafficPolicyInstancesByPolicy$149((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTrafficPolicyVersionsResponse> listTrafficPolicyVersions(ListTrafficPolicyVersionsRequest listTrafficPolicyVersionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listTrafficPolicyVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTrafficPolicyVersions");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTrafficPolicyVersionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrafficPolicyVersions").withMarshaller((Marshaller)new ListTrafficPolicyVersionsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listTrafficPolicyVersionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTrafficPolicyVersionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listTrafficPolicyVersions$151(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listTrafficPolicyVersions$152((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListVpcAssociationAuthorizationsResponse> listVPCAssociationAuthorizations(ListVpcAssociationAuthorizationsRequest listVpcAssociationAuthorizationsRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, listVpcAssociationAuthorizationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVPCAssociationAuthorizations");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListVpcAssociationAuthorizationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVPCAssociationAuthorizations").withMarshaller((Marshaller)new ListVpcAssociationAuthorizationsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listVpcAssociationAuthorizationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listVpcAssociationAuthorizationsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$listVPCAssociationAuthorizations$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$listVPCAssociationAuthorizations$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TestDnsAnswerResponse> testDNSAnswer(TestDnsAnswerRequest testDnsAnswerRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, testDnsAnswerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestDNSAnswer");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(TestDnsAnswerResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestDNSAnswer").withMarshaller((Marshaller)new TestDnsAnswerRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)testDnsAnswerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = testDnsAnswerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$testDNSAnswer$157(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$testDNSAnswer$158((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateHealthCheckResponse> updateHealthCheck(UpdateHealthCheckRequest updateHealthCheckRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, updateHealthCheckRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateHealthCheck");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateHealthCheck").withMarshaller((Marshaller)new UpdateHealthCheckRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)updateHealthCheckRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateHealthCheckRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$updateHealthCheck$160(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$updateHealthCheck$161((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateHostedZoneCommentResponse> updateHostedZoneComment(UpdateHostedZoneCommentRequest updateHostedZoneCommentRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, updateHostedZoneCommentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateHostedZoneComment");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateHostedZoneCommentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateHostedZoneComment").withMarshaller((Marshaller)new UpdateHostedZoneCommentRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)updateHostedZoneCommentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateHostedZoneCommentRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$updateHostedZoneComment$163(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$updateHostedZoneComment$164((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTrafficPolicyCommentResponse> updateTrafficPolicyComment(UpdateTrafficPolicyCommentRequest updateTrafficPolicyCommentRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, updateTrafficPolicyCommentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTrafficPolicyComment");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateTrafficPolicyCommentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTrafficPolicyComment").withMarshaller((Marshaller)new UpdateTrafficPolicyCommentRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)updateTrafficPolicyCommentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateTrafficPolicyCommentRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$updateTrafficPolicyComment$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$updateTrafficPolicyComment$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTrafficPolicyInstanceResponse> updateTrafficPolicyInstance(UpdateTrafficPolicyInstanceRequest updateTrafficPolicyInstanceRequest) {
        List<MetricPublisher> metricPublishers = DefaultRoute53AsyncClient.resolveMetricPublishers(this.clientConfiguration, updateTrafficPolicyInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTrafficPolicyInstance");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateTrafficPolicyInstanceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTrafficPolicyInstance").withMarshaller((Marshaller)new UpdateTrafficPolicyInstanceRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)updateTrafficPolicyInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateTrafficPolicyInstanceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRoute53AsyncClient.lambda$updateTrafficPolicyInstance$169(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRoute53AsyncClient.lambda$updateTrafficPolicyInstance$170((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModification").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTrafficPolicyVersionsForCurrentPolicy").exceptionBuilderSupplier(TooManyTrafficPolicyVersionsForCurrentPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncompatibleVersion").exceptionBuilderSupplier(IncompatibleVersionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("VPCAssociationAuthorizationNotFound").exceptionBuilderSupplier(VpcAssociationAuthorizationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchTrafficPolicy").exceptionBuilderSupplier(NoSuchTrafficPolicyException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTrafficPolicies").exceptionBuilderSupplier(TooManyTrafficPoliciesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegationSetAlreadyCreated").exceptionBuilderSupplier(DelegationSetAlreadyCreatedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchHostedZone").exceptionBuilderSupplier(NoSuchHostedZoneException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QueryLoggingConfigAlreadyExists").exceptionBuilderSupplier(QueryLoggingConfigAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HostedZoneNotPrivate").exceptionBuilderSupplier(HostedZoneNotPrivateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchGeoLocation").exceptionBuilderSupplier(NoSuchGeoLocationException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientCloudWatchLogsResourcePolicy").exceptionBuilderSupplier(InsufficientCloudWatchLogsResourcePolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HealthCheckVersionMismatch").exceptionBuilderSupplier(HealthCheckVersionMismatchException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PublicZoneVPCAssociation").exceptionBuilderSupplier(PublicZoneVpcAssociationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HealthCheckAlreadyExists").exceptionBuilderSupplier(HealthCheckAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchDelegationSet").exceptionBuilderSupplier(NoSuchDelegationSetException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotAuthorizedException").exceptionBuilderSupplier(NotAuthorizedException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("VPCAssociationNotFound").exceptionBuilderSupplier(VpcAssociationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyVPCAssociationAuthorizations").exceptionBuilderSupplier(TooManyVpcAssociationAuthorizationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidVPCId").exceptionBuilderSupplier(InvalidVpcIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTrafficPolicyInstances").exceptionBuilderSupplier(TooManyTrafficPolicyInstancesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPaginationToken").exceptionBuilderSupplier(InvalidPaginationTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegationSetNotAvailable").exceptionBuilderSupplier(DelegationSetNotAvailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchTrafficPolicyInstance").exceptionBuilderSupplier(NoSuchTrafficPolicyInstanceException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HostedZoneNotEmpty").exceptionBuilderSupplier(HostedZoneNotEmptyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDomainName").exceptionBuilderSupplier(InvalidDomainNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyHealthChecks").exceptionBuilderSupplier(TooManyHealthChecksException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidChangeBatch").exceptionBuilderSupplier(InvalidChangeBatchException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HostedZoneAlreadyExists").exceptionBuilderSupplier(HostedZoneAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTrafficPolicyDocument").exceptionBuilderSupplier(InvalidTrafficPolicyDocumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrafficPolicyAlreadyExists").exceptionBuilderSupplier(TrafficPolicyAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegationSetAlreadyReusable").exceptionBuilderSupplier(DelegationSetAlreadyReusableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrafficPolicyInUse").exceptionBuilderSupplier(TrafficPolicyInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyHostedZones").exceptionBuilderSupplier(TooManyHostedZonesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrafficPolicyInstanceAlreadyExists").exceptionBuilderSupplier(TrafficPolicyInstanceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchChange").exceptionBuilderSupplier(NoSuchChangeException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictingTypes").exceptionBuilderSupplier(ConflictingTypesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegationSetNotReusable").exceptionBuilderSupplier(DelegationSetNotReusableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PriorRequestNotComplete").exceptionBuilderSupplier(PriorRequestNotCompleteException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HostedZoneNotFound").exceptionBuilderSupplier(HostedZoneNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgument").exceptionBuilderSupplier(InvalidArgumentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInput").exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictingDomainExists").exceptionBuilderSupplier(ConflictingDomainExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegationSetInUse").exceptionBuilderSupplier(DelegationSetInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchQueryLoggingConfig").exceptionBuilderSupplier(NoSuchQueryLoggingConfigException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchHealthCheck").exceptionBuilderSupplier(NoSuchHealthCheckException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LastVPCAssociation").exceptionBuilderSupplier(LastVpcAssociationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchCloudWatchLogsLogGroup").exceptionBuilderSupplier(NoSuchCloudWatchLogsLogGroupException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitsExceeded").exceptionBuilderSupplier(LimitsExceededException::builder).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(Route53Exception::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends Route53Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.76").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((Route53Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateTrafficPolicyInstance$170(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTrafficPolicyInstance$169(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTrafficPolicyInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateTrafficPolicyComment$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTrafficPolicyComment$166(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTrafficPolicyCommentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateHostedZoneComment$164(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateHostedZoneComment$163(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateHostedZoneCommentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateHealthCheck$161(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateHealthCheck$160(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateHealthCheckResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$testDNSAnswer$158(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testDNSAnswer$157(List metricPublishers, MetricCollector apiCallMetricCollector, TestDnsAnswerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listVPCAssociationAuthorizations$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVPCAssociationAuthorizations$154(List metricPublishers, MetricCollector apiCallMetricCollector, ListVpcAssociationAuthorizationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTrafficPolicyVersions$152(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTrafficPolicyVersions$151(List metricPublishers, MetricCollector apiCallMetricCollector, ListTrafficPolicyVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTrafficPolicyInstancesByPolicy$149(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTrafficPolicyInstancesByPolicy$148(List metricPublishers, MetricCollector apiCallMetricCollector, ListTrafficPolicyInstancesByPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTrafficPolicyInstancesByHostedZone$146(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTrafficPolicyInstancesByHostedZone$145(List metricPublishers, MetricCollector apiCallMetricCollector, ListTrafficPolicyInstancesByHostedZoneResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTrafficPolicyInstances$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTrafficPolicyInstances$142(List metricPublishers, MetricCollector apiCallMetricCollector, ListTrafficPolicyInstancesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTrafficPolicies$140(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTrafficPolicies$139(List metricPublishers, MetricCollector apiCallMetricCollector, ListTrafficPoliciesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResources$137(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResources$136(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourcesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$134(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$133(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listReusableDelegationSets$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReusableDelegationSets$130(List metricPublishers, MetricCollector apiCallMetricCollector, ListReusableDelegationSetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listResourceRecordSets$128(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceRecordSets$127(List metricPublishers, MetricCollector apiCallMetricCollector, ListResourceRecordSetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listQueryLoggingConfigs$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listQueryLoggingConfigs$124(List metricPublishers, MetricCollector apiCallMetricCollector, ListQueryLoggingConfigsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listHostedZonesByVPC$122(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listHostedZonesByVPC$121(List metricPublishers, MetricCollector apiCallMetricCollector, ListHostedZonesByVpcResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listHostedZonesByName$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listHostedZonesByName$118(List metricPublishers, MetricCollector apiCallMetricCollector, ListHostedZonesByNameResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listHostedZones$116(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listHostedZones$115(List metricPublishers, MetricCollector apiCallMetricCollector, ListHostedZonesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listHealthChecks$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listHealthChecks$112(List metricPublishers, MetricCollector apiCallMetricCollector, ListHealthChecksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listGeoLocations$110(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGeoLocations$109(List metricPublishers, MetricCollector apiCallMetricCollector, ListGeoLocationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTrafficPolicyInstanceCount$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTrafficPolicyInstanceCount$106(List metricPublishers, MetricCollector apiCallMetricCollector, GetTrafficPolicyInstanceCountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTrafficPolicyInstance$104(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTrafficPolicyInstance$103(List metricPublishers, MetricCollector apiCallMetricCollector, GetTrafficPolicyInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTrafficPolicy$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTrafficPolicy$100(List metricPublishers, MetricCollector apiCallMetricCollector, GetTrafficPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getReusableDelegationSetLimit$98(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReusableDelegationSetLimit$97(List metricPublishers, MetricCollector apiCallMetricCollector, GetReusableDelegationSetLimitResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getReusableDelegationSet$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReusableDelegationSet$94(List metricPublishers, MetricCollector apiCallMetricCollector, GetReusableDelegationSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getQueryLoggingConfig$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getQueryLoggingConfig$91(List metricPublishers, MetricCollector apiCallMetricCollector, GetQueryLoggingConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getHostedZoneLimit$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getHostedZoneLimit$88(List metricPublishers, MetricCollector apiCallMetricCollector, GetHostedZoneLimitResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getHostedZoneCount$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getHostedZoneCount$85(List metricPublishers, MetricCollector apiCallMetricCollector, GetHostedZoneCountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getHostedZone$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getHostedZone$82(List metricPublishers, MetricCollector apiCallMetricCollector, GetHostedZoneResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getHealthCheckStatus$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getHealthCheckStatus$79(List metricPublishers, MetricCollector apiCallMetricCollector, GetHealthCheckStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getHealthCheckLastFailureReason$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getHealthCheckLastFailureReason$76(List metricPublishers, MetricCollector apiCallMetricCollector, GetHealthCheckLastFailureReasonResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getHealthCheckCount$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getHealthCheckCount$73(List metricPublishers, MetricCollector apiCallMetricCollector, GetHealthCheckCountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getHealthCheck$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getHealthCheck$70(List metricPublishers, MetricCollector apiCallMetricCollector, GetHealthCheckResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getGeoLocation$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGeoLocation$67(List metricPublishers, MetricCollector apiCallMetricCollector, GetGeoLocationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCheckerIpRanges$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCheckerIpRanges$64(List metricPublishers, MetricCollector apiCallMetricCollector, GetCheckerIpRangesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getChange$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getChange$61(List metricPublishers, MetricCollector apiCallMetricCollector, GetChangeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAccountLimit$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccountLimit$58(List metricPublishers, MetricCollector apiCallMetricCollector, GetAccountLimitResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociateVPCFromHostedZone$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateVPCFromHostedZone$55(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociateVpcFromHostedZoneResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteVPCAssociationAuthorization$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVPCAssociationAuthorization$52(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteVpcAssociationAuthorizationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTrafficPolicyInstance$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTrafficPolicyInstance$49(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTrafficPolicyInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTrafficPolicy$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTrafficPolicy$46(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTrafficPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteReusableDelegationSet$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReusableDelegationSet$43(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteReusableDelegationSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteQueryLoggingConfig$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteQueryLoggingConfig$40(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteQueryLoggingConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteHostedZone$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteHostedZone$37(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteHostedZoneResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteHealthCheck$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteHealthCheck$34(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteHealthCheckResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createVPCAssociationAuthorization$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVPCAssociationAuthorization$31(List metricPublishers, MetricCollector apiCallMetricCollector, CreateVpcAssociationAuthorizationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createTrafficPolicyVersion$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTrafficPolicyVersion$28(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTrafficPolicyVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createTrafficPolicyInstance$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTrafficPolicyInstance$25(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTrafficPolicyInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createTrafficPolicy$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTrafficPolicy$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTrafficPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createReusableDelegationSet$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReusableDelegationSet$19(List metricPublishers, MetricCollector apiCallMetricCollector, CreateReusableDelegationSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createQueryLoggingConfig$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createQueryLoggingConfig$16(List metricPublishers, MetricCollector apiCallMetricCollector, CreateQueryLoggingConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createHostedZone$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createHostedZone$13(List metricPublishers, MetricCollector apiCallMetricCollector, CreateHostedZoneResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createHealthCheck$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createHealthCheck$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateHealthCheckResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$changeTagsForResource$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$changeTagsForResource$7(List metricPublishers, MetricCollector apiCallMetricCollector, ChangeTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$changeResourceRecordSets$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$changeResourceRecordSets$4(List metricPublishers, MetricCollector apiCallMetricCollector, ChangeResourceRecordSetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateVPCWithHostedZone$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateVPCWithHostedZone$1(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateVpcWithHostedZoneResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

