/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.route53domains.model.ViewBillingRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ViewBillingRequestModelMarshaller {
    private static final MarshallingInfo<Instant> START_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Start").isBinary(false).build();
    private static final MarshallingInfo<Instant> END_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("End").isBinary(false).build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Marker").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXITEMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxItems").isBinary(false).build();
    private static final ViewBillingRequestModelMarshaller INSTANCE = new ViewBillingRequestModelMarshaller();

    private ViewBillingRequestModelMarshaller() {
    }

    public static ViewBillingRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ViewBillingRequest viewBillingRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)viewBillingRequest), (String)"viewBillingRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)viewBillingRequest.start(), START_BINDING);
            protocolMarshaller.marshall((Object)viewBillingRequest.end(), END_BINDING);
            protocolMarshaller.marshall((Object)viewBillingRequest.marker(), MARKER_BINDING);
            protocolMarshaller.marshall((Object)viewBillingRequest.maxItems(), MAXITEMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

