/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.route53.model.TestDNSAnswerRequest;

public class TestDNSAnswerRequestMarshaller
implements Marshaller<Request<TestDNSAnswerRequest>, TestDNSAnswerRequest> {
    public Request<TestDNSAnswerRequest> marshall(TestDNSAnswerRequest testDNSAnswerRequest) {
        if (testDNSAnswerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)testDNSAnswerRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/testdnsanswer";
        request.setResourcePath(uriResourcePath);
        if (testDNSAnswerRequest.hostedZoneId() != null) {
            request.addParameter("hostedzoneid", StringUtils.fromString((String)testDNSAnswerRequest.hostedZoneId()));
        }
        if (testDNSAnswerRequest.recordName() != null) {
            request.addParameter("recordname", StringUtils.fromString((String)testDNSAnswerRequest.recordName()));
        }
        if (testDNSAnswerRequest.recordTypeString() != null) {
            request.addParameter("recordtype", StringUtils.fromString((String)testDNSAnswerRequest.recordTypeString()));
        }
        if (testDNSAnswerRequest.resolverIP() != null) {
            request.addParameter("resolverip", StringUtils.fromString((String)testDNSAnswerRequest.resolverIP()));
        }
        if (testDNSAnswerRequest.edns0ClientSubnetIP() != null) {
            request.addParameter("edns0clientsubnetip", StringUtils.fromString((String)testDNSAnswerRequest.edns0ClientSubnetIP()));
        }
        if (testDNSAnswerRequest.edns0ClientSubnetMask() != null) {
            request.addParameter("edns0clientsubnetmask", StringUtils.fromString((String)testDNSAnswerRequest.edns0ClientSubnetMask()));
        }
        return request;
    }
}

