/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.route53domains.model.Nameserver;

@SdkInternalApi
public class NameserverMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<List> GLUEIPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlueIps").build();
    private static final NameserverMarshaller INSTANCE = new NameserverMarshaller();

    public static NameserverMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Nameserver nameserver, ProtocolMarshaller protocolMarshaller) {
        if (nameserver == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)nameserver.name(), NAME_BINDING);
            protocolMarshaller.marshall(nameserver.glueIps(), GLUEIPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

