/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.model.HealthCheck;
import software.amazon.awssdk.services.route53.model.ListHealthChecksRequest;
import software.amazon.awssdk.services.route53.model.ListHealthChecksResponse;

public final class ListHealthChecksPaginator
implements SdkIterable<ListHealthChecksResponse> {
    private final Route53Client client;
    private final ListHealthChecksRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListHealthChecksPaginator(Route53Client client, ListHealthChecksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListHealthChecksResponseFetcher();
    }

    public Iterator<ListHealthChecksResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<HealthCheck> healthChecks() {
        Function<ListHealthChecksResponse, Iterator> getIterator = response -> response != null ? response.healthChecks().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListHealthChecksResponseFetcher
    implements NextPageFetcher<ListHealthChecksResponse> {
        private ListHealthChecksResponseFetcher() {
        }

        public boolean hasNextPage(ListHealthChecksResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListHealthChecksResponse nextPage(ListHealthChecksResponse previousPage) {
            if (previousPage == null) {
                return ListHealthChecksPaginator.this.client.listHealthChecks(ListHealthChecksPaginator.this.firstRequest);
            }
            return ListHealthChecksPaginator.this.client.listHealthChecks((ListHealthChecksRequest)((Object)ListHealthChecksPaginator.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

