/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListResourceRecordSetsRequest
extends Route53Request
implements ToCopyableBuilder<Builder, ListResourceRecordSetsRequest> {
    private final String hostedZoneId;
    private final String startRecordName;
    private final String startRecordType;
    private final String startRecordIdentifier;
    private final String maxItems;

    private ListResourceRecordSetsRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.startRecordName = builder.startRecordName;
        this.startRecordType = builder.startRecordType;
        this.startRecordIdentifier = builder.startRecordIdentifier;
        this.maxItems = builder.maxItems;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public String startRecordName() {
        return this.startRecordName;
    }

    public RRType startRecordType() {
        return RRType.fromValue(this.startRecordType);
    }

    public String startRecordTypeString() {
        return this.startRecordType;
    }

    public String startRecordIdentifier() {
        return this.startRecordIdentifier;
    }

    public String maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startRecordName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startRecordTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startRecordIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceRecordSetsRequest)) {
            return false;
        }
        ListResourceRecordSetsRequest other = (ListResourceRecordSetsRequest)((Object)obj);
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.startRecordName(), other.startRecordName()) && Objects.equals(this.startRecordTypeString(), other.startRecordTypeString()) && Objects.equals(this.startRecordIdentifier(), other.startRecordIdentifier()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListResourceRecordSetsRequest").add("HostedZoneId", (Object)this.hostedZoneId()).add("StartRecordName", (Object)this.startRecordName()).add("StartRecordType", (Object)this.startRecordTypeString()).add("StartRecordIdentifier", (Object)this.startRecordIdentifier()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.of(clazz.cast(this.hostedZoneId()));
            }
            case "StartRecordName": {
                return Optional.of(clazz.cast(this.startRecordName()));
            }
            case "StartRecordType": {
                return Optional.of(clazz.cast(this.startRecordTypeString()));
            }
            case "StartRecordIdentifier": {
                return Optional.of(clazz.cast(this.startRecordIdentifier()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private String startRecordName;
        private String startRecordType;
        private String startRecordIdentifier;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceRecordSetsRequest model) {
            this.hostedZoneId(model.hostedZoneId);
            this.startRecordName(model.startRecordName);
            this.startRecordType(model.startRecordType);
            this.startRecordIdentifier(model.startRecordIdentifier);
            this.maxItems(model.maxItems);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getStartRecordName() {
            return this.startRecordName;
        }

        @Override
        public final Builder startRecordName(String startRecordName) {
            this.startRecordName = startRecordName;
            return this;
        }

        public final void setStartRecordName(String startRecordName) {
            this.startRecordName = startRecordName;
        }

        public final String getStartRecordType() {
            return this.startRecordType;
        }

        @Override
        public final Builder startRecordType(String startRecordType) {
            this.startRecordType = startRecordType;
            return this;
        }

        @Override
        public final Builder startRecordType(RRType startRecordType) {
            this.startRecordType(startRecordType.toString());
            return this;
        }

        public final void setStartRecordType(String startRecordType) {
            this.startRecordType = startRecordType;
        }

        public final String getStartRecordIdentifier() {
            return this.startRecordIdentifier;
        }

        @Override
        public final Builder startRecordIdentifier(String startRecordIdentifier) {
            this.startRecordIdentifier = startRecordIdentifier;
            return this;
        }

        public final void setStartRecordIdentifier(String startRecordIdentifier) {
            this.startRecordIdentifier = startRecordIdentifier;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListResourceRecordSetsRequest build() {
            return new ListResourceRecordSetsRequest(this);
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    CopyableBuilder<Builder, ListResourceRecordSetsRequest> {
        public Builder hostedZoneId(String var1);

        public Builder startRecordName(String var1);

        public Builder startRecordType(String var1);

        public Builder startRecordType(RRType var1);

        public Builder startRecordIdentifier(String var1);

        public Builder maxItems(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

