/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RenewDomainRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, RenewDomainRequest> {
    private final String domainName;
    private final Integer durationInYears;
    private final Integer currentExpiryYear;

    private RenewDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.durationInYears = builder.durationInYears;
        this.currentExpiryYear = builder.currentExpiryYear;
    }

    public String domainName() {
        return this.domainName;
    }

    public Integer durationInYears() {
        return this.durationInYears;
    }

    public Integer currentExpiryYear() {
        return this.currentExpiryYear;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInYears());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentExpiryYear());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewDomainRequest)) {
            return false;
        }
        RenewDomainRequest other = (RenewDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.durationInYears(), other.durationInYears()) && Objects.equals(this.currentExpiryYear(), other.currentExpiryYear());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.durationInYears() != null) {
            sb.append("DurationInYears: ").append(this.durationInYears()).append(",");
        }
        if (this.currentExpiryYear() != null) {
            sb.append("CurrentExpiryYear: ").append(this.currentExpiryYear()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "DurationInYears": {
                return Optional.of(clazz.cast(this.durationInYears()));
            }
            case "CurrentExpiryYear": {
                return Optional.of(clazz.cast(this.currentExpiryYear()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private Integer durationInYears;
        private Integer currentExpiryYear;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewDomainRequest model) {
            this.domainName(model.domainName);
            this.durationInYears(model.durationInYears);
            this.currentExpiryYear(model.currentExpiryYear);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Integer getDurationInYears() {
            return this.durationInYears;
        }

        @Override
        public final Builder durationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
            return this;
        }

        public final void setDurationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
        }

        public final Integer getCurrentExpiryYear() {
            return this.currentExpiryYear;
        }

        @Override
        public final Builder currentExpiryYear(Integer currentExpiryYear) {
            this.currentExpiryYear = currentExpiryYear;
            return this;
        }

        public final void setCurrentExpiryYear(Integer currentExpiryYear) {
            this.currentExpiryYear = currentExpiryYear;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RenewDomainRequest build() {
            return new RenewDomainRequest(this);
        }
    }

    public static interface Builder
    extends Route53DomainsRequest.Builder,
    CopyableBuilder<Builder, RenewDomainRequest> {
        public Builder domainName(String var1);

        public Builder durationInYears(Integer var1);

        public Builder currentExpiryYear(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

