/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;

public final class ListResourceRecordSetsPaginator
implements SdkIterable<ListResourceRecordSetsResponse> {
    private final Route53Client client;
    private final ListResourceRecordSetsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListResourceRecordSetsPaginator(Route53Client client, ListResourceRecordSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListResourceRecordSetsResponseFetcher();
    }

    public Iterator<ListResourceRecordSetsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ResourceRecordSet> resourceRecordSets() {
        Function<ListResourceRecordSetsResponse, Iterator> getIterator = response -> response != null ? response.resourceRecordSets().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListResourceRecordSetsResponseFetcher
    implements NextPageFetcher<ListResourceRecordSetsResponse> {
        private ListResourceRecordSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceRecordSetsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListResourceRecordSetsResponse nextPage(ListResourceRecordSetsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceRecordSetsPaginator.this.client.listResourceRecordSets(ListResourceRecordSetsPaginator.this.firstRequest);
            }
            return ListResourceRecordSetsPaginator.this.client.listResourceRecordSets((ListResourceRecordSetsRequest)((Object)ListResourceRecordSetsPaginator.this.firstRequest.toBuilder().startRecordName(previousPage.nextRecordName()).startRecordType(previousPage.nextRecordTypeString()).startRecordIdentifier(previousPage.nextRecordIdentifier()).build()));
        }
    }
}

