/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.HostedZonesCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListHostedZonesResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListHostedZonesResponse> {
    private final List<HostedZone> hostedZones;
    private final String marker;
    private final Boolean isTruncated;
    private final String nextMarker;
    private final String maxItems;

    private ListHostedZonesResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZones = builder.hostedZones;
        this.marker = builder.marker;
        this.isTruncated = builder.isTruncated;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
    }

    public List<HostedZone> hostedZones() {
        return this.hostedZones;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesResponse)) {
            return false;
        }
        ListHostedZonesResponse other = (ListHostedZonesResponse)((Object)obj);
        return Objects.equals(this.hostedZones(), other.hostedZones()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hostedZones() != null) {
            sb.append("HostedZones: ").append(this.hostedZones()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZones": {
                return Optional.of(clazz.cast(this.hostedZones()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<HostedZone> hostedZones;
        private String marker;
        private Boolean isTruncated;
        private String nextMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesResponse model) {
            this.hostedZones(model.hostedZones);
            this.marker(model.marker);
            this.isTruncated(model.isTruncated);
            this.nextMarker(model.nextMarker);
            this.maxItems(model.maxItems);
        }

        public final Collection<HostedZone.Builder> getHostedZones() {
            return this.hostedZones != null ? (Collection)this.hostedZones.stream().map(HostedZone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hostedZones(Collection<HostedZone> hostedZones) {
            this.hostedZones = HostedZonesCopier.copy(hostedZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZones(HostedZone ... hostedZones) {
            this.hostedZones(Arrays.asList(hostedZones));
            return this;
        }

        public final void setHostedZones(Collection<HostedZone.BuilderImpl> hostedZones) {
            this.hostedZones = HostedZonesCopier.copyFromBuilder(hostedZones);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListHostedZonesResponse build() {
            return new ListHostedZonesResponse(this);
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    CopyableBuilder<Builder, ListHostedZonesResponse> {
        public Builder hostedZones(Collection<HostedZone> var1);

        public Builder hostedZones(HostedZone ... var1);

        public Builder marker(String var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextMarker(String var1);

        public Builder maxItems(String var1);
    }
}

