/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.route53domains.model.DomainSummary;
import software.amazon.awssdk.services.route53domains.model.DomainSummaryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDomainsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDomainsResponse> {
    private final List<DomainSummary> domains;
    private final String nextPageMarker;

    private ListDomainsResponse(BuilderImpl builder) {
        this.domains = builder.domains;
        this.nextPageMarker = builder.nextPageMarker;
    }

    public List<DomainSummary> domains() {
        return this.domains;
    }

    public String nextPageMarker() {
        return this.nextPageMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domains());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsResponse)) {
            return false;
        }
        ListDomainsResponse other = (ListDomainsResponse)((Object)obj);
        return Objects.equals(this.domains(), other.domains()) && Objects.equals(this.nextPageMarker(), other.nextPageMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domains() != null) {
            sb.append("Domains: ").append(this.domains()).append(",");
        }
        if (this.nextPageMarker() != null) {
            sb.append("NextPageMarker: ").append(this.nextPageMarker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domains": {
                return Optional.of(clazz.cast(this.domains()));
            }
            case "NextPageMarker": {
                return Optional.of(clazz.cast(this.nextPageMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<DomainSummary> domains;
        private String nextPageMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsResponse model) {
            this.domains(model.domains);
            this.nextPageMarker(model.nextPageMarker);
        }

        public final Collection<DomainSummary.Builder> getDomains() {
            return this.domains != null ? (Collection)this.domains.stream().map(DomainSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domains(Collection<DomainSummary> domains) {
            this.domains = DomainSummaryListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(DomainSummary ... domains) {
            this.domains(Arrays.asList(domains));
            return this;
        }

        public final void setDomains(Collection<DomainSummary.BuilderImpl> domains) {
            this.domains = DomainSummaryListCopier.copyFromBuilder(domains);
        }

        public final String getNextPageMarker() {
            return this.nextPageMarker;
        }

        @Override
        public final Builder nextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
            return this;
        }

        public final void setNextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
        }

        public ListDomainsResponse build() {
            return new ListDomainsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDomainsResponse> {
        public Builder domains(Collection<DomainSummary> var1);

        public Builder domains(DomainSummary ... var1);

        public Builder nextPageMarker(String var1);
    }
}

