/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.route53domains.model.OperationStatus;
import software.amazon.awssdk.services.route53domains.model.OperationType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetOperationDetailResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetOperationDetailResponse> {
    private final String operationId;
    private final String status;
    private final String message;
    private final String domainName;
    private final String type;
    private final Instant submittedDate;

    private GetOperationDetailResponse(BuilderImpl builder) {
        this.operationId = builder.operationId;
        this.status = builder.status;
        this.message = builder.message;
        this.domainName = builder.domainName;
        this.type = builder.type;
        this.submittedDate = builder.submittedDate;
    }

    public String operationId() {
        return this.operationId;
    }

    public OperationStatus status() {
        return OperationStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public String domainName() {
        return this.domainName;
    }

    public OperationType type() {
        return OperationType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Instant submittedDate() {
        return this.submittedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationDetailResponse)) {
            return false;
        }
        GetOperationDetailResponse other = (GetOperationDetailResponse)((Object)obj);
        return Objects.equals(this.operationId(), other.operationId()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.submittedDate(), other.submittedDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.operationId() != null) {
            sb.append("OperationId: ").append(this.operationId()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.submittedDate() != null) {
            sb.append("SubmittedDate: ").append(this.submittedDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperationId": {
                return Optional.of(clazz.cast(this.operationId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "SubmittedDate": {
                return Optional.of(clazz.cast(this.submittedDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String operationId;
        private String status;
        private String message;
        private String domainName;
        private String type;
        private Instant submittedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationDetailResponse model) {
            this.operationId(model.operationId);
            this.status(model.status);
            this.message(model.message);
            this.domainName(model.domainName);
            this.type(model.type);
            this.submittedDate(model.submittedDate);
        }

        public final String getOperationId() {
            return this.operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getSubmittedDate() {
            return this.submittedDate;
        }

        @Override
        public final Builder submittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
            return this;
        }

        public final void setSubmittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
        }

        public GetOperationDetailResponse build() {
            return new GetOperationDetailResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetOperationDetailResponse> {
        public Builder operationId(String var1);

        public Builder status(String var1);

        public Builder status(OperationStatus var1);

        public Builder message(String var1);

        public Builder domainName(String var1);

        public Builder type(String var1);

        public Builder type(OperationType var1);

        public Builder submittedDate(Instant var1);
    }
}

