/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.AliasTarget;

public class AliasTargetUnmarshaller
implements Unmarshaller<AliasTarget, StaxUnmarshallerContext> {
    private static final AliasTargetUnmarshaller INSTANCE = new AliasTargetUnmarshaller();

    public AliasTarget unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        AliasTarget.Builder aliasTarget = AliasTarget.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("HostedZoneId", targetDepth)) {
                    aliasTarget.hostedZoneId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DNSName", targetDepth)) {
                    aliasTarget.dnsName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EvaluateTargetHealth", targetDepth)) continue;
                aliasTarget.evaluateTargetHealth(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (AliasTarget)aliasTarget.build();
    }

    public static AliasTargetUnmarshaller getInstance() {
        return INSTANCE;
    }
}

