/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateTrafficPolicyInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateTrafficPolicyInstanceRequest> {
    private final String id;
    private final Long ttl;
    private final String trafficPolicyId;
    private final Integer trafficPolicyVersion;

    private UpdateTrafficPolicyInstanceRequest(BuilderImpl builder) {
        this.id = builder.id;
        this.ttl = builder.ttl;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.trafficPolicyVersion = builder.trafficPolicyVersion;
    }

    public String id() {
        return this.id;
    }

    public Long ttl() {
        return this.ttl;
    }

    public String trafficPolicyId() {
        return this.trafficPolicyId;
    }

    public Integer trafficPolicyVersion() {
        return this.trafficPolicyVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrafficPolicyInstanceRequest)) {
            return false;
        }
        UpdateTrafficPolicyInstanceRequest other = (UpdateTrafficPolicyInstanceRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.ttl(), other.ttl()) && Objects.equals(this.trafficPolicyId(), other.trafficPolicyId()) && Objects.equals(this.trafficPolicyVersion(), other.trafficPolicyVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.ttl() != null) {
            sb.append("TTL: ").append(this.ttl()).append(",");
        }
        if (this.trafficPolicyId() != null) {
            sb.append("TrafficPolicyId: ").append(this.trafficPolicyId()).append(",");
        }
        if (this.trafficPolicyVersion() != null) {
            sb.append("TrafficPolicyVersion: ").append(this.trafficPolicyVersion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "TTL": {
                return Optional.of(clazz.cast(this.ttl()));
            }
            case "TrafficPolicyId": {
                return Optional.of(clazz.cast(this.trafficPolicyId()));
            }
            case "TrafficPolicyVersion": {
                return Optional.of(clazz.cast(this.trafficPolicyVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Long ttl;
        private String trafficPolicyId;
        private Integer trafficPolicyVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrafficPolicyInstanceRequest model) {
            this.id(model.id);
            this.ttl(model.ttl);
            this.trafficPolicyId(model.trafficPolicyId);
            this.trafficPolicyVersion(model.trafficPolicyVersion);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Long getTTL() {
            return this.ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTTL(Long ttl) {
            this.ttl = ttl;
        }

        public final String getTrafficPolicyId() {
            return this.trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        public final Integer getTrafficPolicyVersion() {
            return this.trafficPolicyVersion;
        }

        @Override
        public final Builder trafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
            return this;
        }

        public final void setTrafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
        }

        public UpdateTrafficPolicyInstanceRequest build() {
            return new UpdateTrafficPolicyInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateTrafficPolicyInstanceRequest> {
        public Builder id(String var1);

        public Builder ttl(Long var1);

        public Builder trafficPolicyId(String var1);

        public Builder trafficPolicyVersion(Integer var1);
    }
}

