/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RenewDomainRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RenewDomainRequest> {
    private final String domainName;
    private final Integer durationInYears;
    private final Integer currentExpiryYear;

    private RenewDomainRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.durationInYears = builder.durationInYears;
        this.currentExpiryYear = builder.currentExpiryYear;
    }

    public String domainName() {
        return this.domainName;
    }

    public Integer durationInYears() {
        return this.durationInYears;
    }

    public Integer currentExpiryYear() {
        return this.currentExpiryYear;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.durationInYears() == null ? 0 : this.durationInYears().hashCode());
        hashCode = 31 * hashCode + (this.currentExpiryYear() == null ? 0 : this.currentExpiryYear().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewDomainRequest)) {
            return false;
        }
        RenewDomainRequest other = (RenewDomainRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.durationInYears() == null ^ this.durationInYears() == null) {
            return false;
        }
        if (other.durationInYears() != null && !other.durationInYears().equals(this.durationInYears())) {
            return false;
        }
        if (other.currentExpiryYear() == null ^ this.currentExpiryYear() == null) {
            return false;
        }
        return other.currentExpiryYear() == null || other.currentExpiryYear().equals(this.currentExpiryYear());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.durationInYears() != null) {
            sb.append("DurationInYears: ").append(this.durationInYears()).append(",");
        }
        if (this.currentExpiryYear() != null) {
            sb.append("CurrentExpiryYear: ").append(this.currentExpiryYear()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "DurationInYears": {
                return Optional.of(clazz.cast(this.durationInYears()));
            }
            case "CurrentExpiryYear": {
                return Optional.of(clazz.cast(this.currentExpiryYear()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private Integer durationInYears;
        private Integer currentExpiryYear;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewDomainRequest model) {
            this.domainName(model.domainName);
            this.durationInYears(model.durationInYears);
            this.currentExpiryYear(model.currentExpiryYear);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Integer getDurationInYears() {
            return this.durationInYears;
        }

        @Override
        public final Builder durationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
            return this;
        }

        public final void setDurationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
        }

        public final Integer getCurrentExpiryYear() {
            return this.currentExpiryYear;
        }

        @Override
        public final Builder currentExpiryYear(Integer currentExpiryYear) {
            this.currentExpiryYear = currentExpiryYear;
            return this;
        }

        public final void setCurrentExpiryYear(Integer currentExpiryYear) {
            this.currentExpiryYear = currentExpiryYear;
        }

        public RenewDomainRequest build() {
            return new RenewDomainRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RenewDomainRequest> {
        public Builder domainName(String var1);

        public Builder durationInYears(Integer var1);

        public Builder currentExpiryYear(Integer var1);
    }
}

