/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.route53domains.model.OperationSummary;
import software.amazon.awssdk.services.route53domains.model.OperationSummaryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOperationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListOperationsResponse> {
    private final List<OperationSummary> operations;
    private final String nextPageMarker;

    private ListOperationsResponse(BuilderImpl builder) {
        this.operations = builder.operations;
        this.nextPageMarker = builder.nextPageMarker;
    }

    public List<OperationSummary> operations() {
        return this.operations;
    }

    public String nextPageMarker() {
        return this.nextPageMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.operations() == null ? 0 : this.operations().hashCode());
        hashCode = 31 * hashCode + (this.nextPageMarker() == null ? 0 : this.nextPageMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsResponse)) {
            return false;
        }
        ListOperationsResponse other = (ListOperationsResponse)((Object)obj);
        if (other.operations() == null ^ this.operations() == null) {
            return false;
        }
        if (other.operations() != null && !other.operations().equals(this.operations())) {
            return false;
        }
        if (other.nextPageMarker() == null ^ this.nextPageMarker() == null) {
            return false;
        }
        return other.nextPageMarker() == null || other.nextPageMarker().equals(this.nextPageMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.operations() != null) {
            sb.append("Operations: ").append(this.operations()).append(",");
        }
        if (this.nextPageMarker() != null) {
            sb.append("NextPageMarker: ").append(this.nextPageMarker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Operations": {
                return Optional.of(clazz.cast(this.operations()));
            }
            case "NextPageMarker": {
                return Optional.of(clazz.cast(this.nextPageMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<OperationSummary> operations;
        private String nextPageMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationsResponse model) {
            this.operations(model.operations);
            this.nextPageMarker(model.nextPageMarker);
        }

        public final Collection<OperationSummary.Builder> getOperations() {
            return this.operations != null ? (Collection)this.operations.stream().map(OperationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<OperationSummary> operations) {
            this.operations = OperationSummaryListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(OperationSummary ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<OperationSummary.BuilderImpl> operations) {
            this.operations = OperationSummaryListCopier.copyFromBuilder(operations);
        }

        public final String getNextPageMarker() {
            return this.nextPageMarker;
        }

        @Override
        public final Builder nextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
            return this;
        }

        public final void setNextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
        }

        public ListOperationsResponse build() {
            return new ListOperationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListOperationsResponse> {
        public Builder operations(Collection<OperationSummary> var1);

        public Builder operations(OperationSummary ... var1);

        public Builder nextPageMarker(String var1);
    }
}

